package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class TaxedItemPrice {
  private Money totalNet;

  private Money totalGross;

  private List<TaxPortion> taxPortions;

  private Money totalTax;

  public TaxedItemPrice() {
  }

  public TaxedItemPrice(Money totalNet, Money totalGross, List<TaxPortion> taxPortions,
      Money totalTax) {
    this.totalNet = totalNet;
    this.totalGross = totalGross;
    this.taxPortions = taxPortions;
    this.totalTax = totalTax;
  }

  public Money getTotalNet() {
    return totalNet;
  }

  public void setTotalNet(Money totalNet) {
    this.totalNet = totalNet;
  }

  public Money getTotalGross() {
    return totalGross;
  }

  public void setTotalGross(Money totalGross) {
    this.totalGross = totalGross;
  }

  public List<TaxPortion> getTaxPortions() {
    return taxPortions;
  }

  public void setTaxPortions(List<TaxPortion> taxPortions) {
    this.taxPortions = taxPortions;
  }

  public Money getTotalTax() {
    return totalTax;
  }

  public void setTotalTax(Money totalTax) {
    this.totalTax = totalTax;
  }

  @Override
  public String toString() {
    return "TaxedItemPrice{totalNet='" + totalNet + "', totalGross='" + totalGross + "', taxPortions='" + taxPortions + "', totalTax='" + totalTax + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TaxedItemPrice that = (TaxedItemPrice) o;
    return Objects.equals(totalNet, that.totalNet) &&
        Objects.equals(totalGross, that.totalGross) &&
        Objects.equals(taxPortions, that.taxPortions) &&
        Objects.equals(totalTax, that.totalTax);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalNet, totalGross, taxPortions, totalTax);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Money totalNet;

    private Money totalGross;

    private List<TaxPortion> taxPortions;

    private Money totalTax;

    public TaxedItemPrice build() {
      TaxedItemPrice result = new TaxedItemPrice();
      result.totalNet = this.totalNet;
      result.totalGross = this.totalGross;
      result.taxPortions = this.taxPortions;
      result.totalTax = this.totalTax;
      return result;
    }

    public Builder totalNet(Money totalNet) {
      this.totalNet = totalNet;
      return this;
    }

    public Builder totalGross(Money totalGross) {
      this.totalGross = totalGross;
      return this;
    }

    public Builder taxPortions(List<TaxPortion> taxPortions) {
      this.taxPortions = taxPortions;
      return this;
    }

    public Builder totalTax(Money totalTax) {
      this.totalTax = totalTax;
      return this;
    }
  }
}
