package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class TransactionDraft {
  private OffsetDateTime timestamp;

  private TransactionType type;

  private MoneyInput amount;

  private String interactionId;

  private TransactionState state;

  private CustomFieldsDraft custom;

  public TransactionDraft() {
  }

  public TransactionDraft(OffsetDateTime timestamp, TransactionType type, MoneyInput amount,
      String interactionId, TransactionState state, CustomFieldsDraft custom) {
    this.timestamp = timestamp;
    this.type = type;
    this.amount = amount;
    this.interactionId = interactionId;
    this.state = state;
    this.custom = custom;
  }

  public OffsetDateTime getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(OffsetDateTime timestamp) {
    this.timestamp = timestamp;
  }

  public TransactionType getType() {
    return type;
  }

  public void setType(TransactionType type) {
    this.type = type;
  }

  public MoneyInput getAmount() {
    return amount;
  }

  public void setAmount(MoneyInput amount) {
    this.amount = amount;
  }

  public String getInteractionId() {
    return interactionId;
  }

  public void setInteractionId(String interactionId) {
    this.interactionId = interactionId;
  }

  public TransactionState getState() {
    return state;
  }

  public void setState(TransactionState state) {
    this.state = state;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "TransactionDraft{timestamp='" + timestamp + "', type='" + type + "', amount='" + amount + "', interactionId='" + interactionId + "', state='" + state + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TransactionDraft that = (TransactionDraft) o;
    return Objects.equals(timestamp, that.timestamp) &&
        Objects.equals(type, that.type) &&
        Objects.equals(amount, that.amount) &&
        Objects.equals(interactionId, that.interactionId) &&
        Objects.equals(state, that.state) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(timestamp, type, amount, interactionId, state, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime timestamp;

    private TransactionType type;

    private MoneyInput amount;

    private String interactionId;

    private TransactionState state;

    private CustomFieldsDraft custom;

    public TransactionDraft build() {
      TransactionDraft result = new TransactionDraft();
      result.timestamp = this.timestamp;
      result.type = this.type;
      result.amount = this.amount;
      result.interactionId = this.interactionId;
      result.state = this.state;
      result.custom = this.custom;
      return result;
    }

    public Builder timestamp(OffsetDateTime timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    public Builder type(TransactionType type) {
      this.type = type;
      return this;
    }

    public Builder amount(MoneyInput amount) {
      this.amount = amount;
      return this;
    }

    public Builder interactionId(String interactionId) {
      this.interactionId = interactionId;
      return this;
    }

    public Builder state(TransactionState state) {
      this.state = state;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
