package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class TransitionOrderLineItemState {
  private String lineItemId;

  private String lineItemKey;

  private Long quantity;

  private ResourceIdentifierInput fromState;

  private ResourceIdentifierInput toState;

  private OffsetDateTime actualTransitionDate;

  public TransitionOrderLineItemState() {
  }

  public TransitionOrderLineItemState(String lineItemId, String lineItemKey, Long quantity,
      ResourceIdentifierInput fromState, ResourceIdentifierInput toState,
      OffsetDateTime actualTransitionDate) {
    this.lineItemId = lineItemId;
    this.lineItemKey = lineItemKey;
    this.quantity = quantity;
    this.fromState = fromState;
    this.toState = toState;
    this.actualTransitionDate = actualTransitionDate;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public ResourceIdentifierInput getFromState() {
    return fromState;
  }

  public void setFromState(ResourceIdentifierInput fromState) {
    this.fromState = fromState;
  }

  public ResourceIdentifierInput getToState() {
    return toState;
  }

  public void setToState(ResourceIdentifierInput toState) {
    this.toState = toState;
  }

  public OffsetDateTime getActualTransitionDate() {
    return actualTransitionDate;
  }

  public void setActualTransitionDate(OffsetDateTime actualTransitionDate) {
    this.actualTransitionDate = actualTransitionDate;
  }

  @Override
  public String toString() {
    return "TransitionOrderLineItemState{lineItemId='" + lineItemId + "', lineItemKey='" + lineItemKey + "', quantity='" + quantity + "', fromState='" + fromState + "', toState='" + toState + "', actualTransitionDate='" + actualTransitionDate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TransitionOrderLineItemState that = (TransitionOrderLineItemState) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(lineItemKey, that.lineItemKey) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(fromState, that.fromState) &&
        Objects.equals(toState, that.toState) &&
        Objects.equals(actualTransitionDate, that.actualTransitionDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, lineItemKey, quantity, fromState, toState, actualTransitionDate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private String lineItemKey;

    private Long quantity;

    private ResourceIdentifierInput fromState;

    private ResourceIdentifierInput toState;

    private OffsetDateTime actualTransitionDate;

    public TransitionOrderLineItemState build() {
      TransitionOrderLineItemState result = new TransitionOrderLineItemState();
      result.lineItemId = this.lineItemId;
      result.lineItemKey = this.lineItemKey;
      result.quantity = this.quantity;
      result.fromState = this.fromState;
      result.toState = this.toState;
      result.actualTransitionDate = this.actualTransitionDate;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder fromState(ResourceIdentifierInput fromState) {
      this.fromState = fromState;
      return this;
    }

    public Builder toState(ResourceIdentifierInput toState) {
      this.toState = toState;
      return this;
    }

    public Builder actualTransitionDate(OffsetDateTime actualTransitionDate) {
      this.actualTransitionDate = actualTransitionDate;
      return this;
    }
  }
}
