package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class TransitionPaymentState {
  private ResourceIdentifierInput state;

  private Boolean force = false;

  public TransitionPaymentState() {
  }

  public TransitionPaymentState(ResourceIdentifierInput state, Boolean force) {
    this.state = state;
    this.force = force;
  }

  public ResourceIdentifierInput getState() {
    return state;
  }

  public void setState(ResourceIdentifierInput state) {
    this.state = state;
  }

  public Boolean getForce() {
    return force;
  }

  public void setForce(Boolean force) {
    this.force = force;
  }

  @Override
  public String toString() {
    return "TransitionPaymentState{state='" + state + "', force='" + force + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TransitionPaymentState that = (TransitionPaymentState) o;
    return Objects.equals(state, that.state) &&
        Objects.equals(force, that.force);
  }

  @Override
  public int hashCode() {
    return Objects.hash(state, force);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput state;

    private Boolean force = false;

    public TransitionPaymentState build() {
      TransitionPaymentState result = new TransitionPaymentState();
      result.state = this.state;
      result.force = this.force;
      return result;
    }

    public Builder state(ResourceIdentifierInput state) {
      this.state = state;
      return this;
    }

    public Builder force(Boolean force) {
      this.force = force;
      return this;
    }
  }
}
