package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class TypeUpdateAction {
  private AddTypeEnumValue addEnumValue;

  private AddTypeFieldDefinition addFieldDefinition;

  private AddTypeLocalizedEnumValue addLocalizedEnumValue;

  private ChangeTypeEnumValueLabel changeEnumValueLabel;

  private ChangeTypeEnumValueOrder changeEnumValueOrder;

  private ChangeTypeLabel changeLabel;

  private ChangeTypeFieldDefinitionOrder changeFieldDefinitionOrder;

  private ChangeTypeInputHint changeInputHint;

  private ChangeTypeLocalizedEnumValueLabel changeLocalizedEnumValueLabel;

  private ChangeTypeLocalizedEnumValueOrder changeLocalizedEnumValueOrder;

  private ChangeTypeKey changeKey;

  private ChangeTypeName changeName;

  private RemoveTypeFieldDefinition removeFieldDefinition;

  private SetTypeDescription setDescription;

  public TypeUpdateAction() {
  }

  public TypeUpdateAction(AddTypeEnumValue addEnumValue, AddTypeFieldDefinition addFieldDefinition,
      AddTypeLocalizedEnumValue addLocalizedEnumValue,
      ChangeTypeEnumValueLabel changeEnumValueLabel, ChangeTypeEnumValueOrder changeEnumValueOrder,
      ChangeTypeLabel changeLabel, ChangeTypeFieldDefinitionOrder changeFieldDefinitionOrder,
      ChangeTypeInputHint changeInputHint,
      ChangeTypeLocalizedEnumValueLabel changeLocalizedEnumValueLabel,
      ChangeTypeLocalizedEnumValueOrder changeLocalizedEnumValueOrder, ChangeTypeKey changeKey,
      ChangeTypeName changeName, RemoveTypeFieldDefinition removeFieldDefinition,
      SetTypeDescription setDescription) {
    this.addEnumValue = addEnumValue;
    this.addFieldDefinition = addFieldDefinition;
    this.addLocalizedEnumValue = addLocalizedEnumValue;
    this.changeEnumValueLabel = changeEnumValueLabel;
    this.changeEnumValueOrder = changeEnumValueOrder;
    this.changeLabel = changeLabel;
    this.changeFieldDefinitionOrder = changeFieldDefinitionOrder;
    this.changeInputHint = changeInputHint;
    this.changeLocalizedEnumValueLabel = changeLocalizedEnumValueLabel;
    this.changeLocalizedEnumValueOrder = changeLocalizedEnumValueOrder;
    this.changeKey = changeKey;
    this.changeName = changeName;
    this.removeFieldDefinition = removeFieldDefinition;
    this.setDescription = setDescription;
  }

  public AddTypeEnumValue getAddEnumValue() {
    return addEnumValue;
  }

  public void setAddEnumValue(AddTypeEnumValue addEnumValue) {
    this.addEnumValue = addEnumValue;
  }

  public AddTypeFieldDefinition getAddFieldDefinition() {
    return addFieldDefinition;
  }

  public void setAddFieldDefinition(AddTypeFieldDefinition addFieldDefinition) {
    this.addFieldDefinition = addFieldDefinition;
  }

  public AddTypeLocalizedEnumValue getAddLocalizedEnumValue() {
    return addLocalizedEnumValue;
  }

  public void setAddLocalizedEnumValue(AddTypeLocalizedEnumValue addLocalizedEnumValue) {
    this.addLocalizedEnumValue = addLocalizedEnumValue;
  }

  public ChangeTypeEnumValueLabel getChangeEnumValueLabel() {
    return changeEnumValueLabel;
  }

  public void setChangeEnumValueLabel(ChangeTypeEnumValueLabel changeEnumValueLabel) {
    this.changeEnumValueLabel = changeEnumValueLabel;
  }

  public ChangeTypeEnumValueOrder getChangeEnumValueOrder() {
    return changeEnumValueOrder;
  }

  public void setChangeEnumValueOrder(ChangeTypeEnumValueOrder changeEnumValueOrder) {
    this.changeEnumValueOrder = changeEnumValueOrder;
  }

  public ChangeTypeLabel getChangeLabel() {
    return changeLabel;
  }

  public void setChangeLabel(ChangeTypeLabel changeLabel) {
    this.changeLabel = changeLabel;
  }

  public ChangeTypeFieldDefinitionOrder getChangeFieldDefinitionOrder() {
    return changeFieldDefinitionOrder;
  }

  public void setChangeFieldDefinitionOrder(
      ChangeTypeFieldDefinitionOrder changeFieldDefinitionOrder) {
    this.changeFieldDefinitionOrder = changeFieldDefinitionOrder;
  }

  public ChangeTypeInputHint getChangeInputHint() {
    return changeInputHint;
  }

  public void setChangeInputHint(ChangeTypeInputHint changeInputHint) {
    this.changeInputHint = changeInputHint;
  }

  public ChangeTypeLocalizedEnumValueLabel getChangeLocalizedEnumValueLabel() {
    return changeLocalizedEnumValueLabel;
  }

  public void setChangeLocalizedEnumValueLabel(
      ChangeTypeLocalizedEnumValueLabel changeLocalizedEnumValueLabel) {
    this.changeLocalizedEnumValueLabel = changeLocalizedEnumValueLabel;
  }

  public ChangeTypeLocalizedEnumValueOrder getChangeLocalizedEnumValueOrder() {
    return changeLocalizedEnumValueOrder;
  }

  public void setChangeLocalizedEnumValueOrder(
      ChangeTypeLocalizedEnumValueOrder changeLocalizedEnumValueOrder) {
    this.changeLocalizedEnumValueOrder = changeLocalizedEnumValueOrder;
  }

  public ChangeTypeKey getChangeKey() {
    return changeKey;
  }

  public void setChangeKey(ChangeTypeKey changeKey) {
    this.changeKey = changeKey;
  }

  public ChangeTypeName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeTypeName changeName) {
    this.changeName = changeName;
  }

  public RemoveTypeFieldDefinition getRemoveFieldDefinition() {
    return removeFieldDefinition;
  }

  public void setRemoveFieldDefinition(RemoveTypeFieldDefinition removeFieldDefinition) {
    this.removeFieldDefinition = removeFieldDefinition;
  }

  public SetTypeDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(SetTypeDescription setDescription) {
    this.setDescription = setDescription;
  }

  @Override
  public String toString() {
    return "TypeUpdateAction{addEnumValue='" + addEnumValue + "', addFieldDefinition='" + addFieldDefinition + "', addLocalizedEnumValue='" + addLocalizedEnumValue + "', changeEnumValueLabel='" + changeEnumValueLabel + "', changeEnumValueOrder='" + changeEnumValueOrder + "', changeLabel='" + changeLabel + "', changeFieldDefinitionOrder='" + changeFieldDefinitionOrder + "', changeInputHint='" + changeInputHint + "', changeLocalizedEnumValueLabel='" + changeLocalizedEnumValueLabel + "', changeLocalizedEnumValueOrder='" + changeLocalizedEnumValueOrder + "', changeKey='" + changeKey + "', changeName='" + changeName + "', removeFieldDefinition='" + removeFieldDefinition + "', setDescription='" + setDescription + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TypeUpdateAction that = (TypeUpdateAction) o;
    return Objects.equals(addEnumValue, that.addEnumValue) &&
        Objects.equals(addFieldDefinition, that.addFieldDefinition) &&
        Objects.equals(addLocalizedEnumValue, that.addLocalizedEnumValue) &&
        Objects.equals(changeEnumValueLabel, that.changeEnumValueLabel) &&
        Objects.equals(changeEnumValueOrder, that.changeEnumValueOrder) &&
        Objects.equals(changeLabel, that.changeLabel) &&
        Objects.equals(changeFieldDefinitionOrder, that.changeFieldDefinitionOrder) &&
        Objects.equals(changeInputHint, that.changeInputHint) &&
        Objects.equals(changeLocalizedEnumValueLabel, that.changeLocalizedEnumValueLabel) &&
        Objects.equals(changeLocalizedEnumValueOrder, that.changeLocalizedEnumValueOrder) &&
        Objects.equals(changeKey, that.changeKey) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(removeFieldDefinition, that.removeFieldDefinition) &&
        Objects.equals(setDescription, that.setDescription);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addEnumValue, addFieldDefinition, addLocalizedEnumValue, changeEnumValueLabel, changeEnumValueOrder, changeLabel, changeFieldDefinitionOrder, changeInputHint, changeLocalizedEnumValueLabel, changeLocalizedEnumValueOrder, changeKey, changeName, removeFieldDefinition, setDescription);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddTypeEnumValue addEnumValue;

    private AddTypeFieldDefinition addFieldDefinition;

    private AddTypeLocalizedEnumValue addLocalizedEnumValue;

    private ChangeTypeEnumValueLabel changeEnumValueLabel;

    private ChangeTypeEnumValueOrder changeEnumValueOrder;

    private ChangeTypeLabel changeLabel;

    private ChangeTypeFieldDefinitionOrder changeFieldDefinitionOrder;

    private ChangeTypeInputHint changeInputHint;

    private ChangeTypeLocalizedEnumValueLabel changeLocalizedEnumValueLabel;

    private ChangeTypeLocalizedEnumValueOrder changeLocalizedEnumValueOrder;

    private ChangeTypeKey changeKey;

    private ChangeTypeName changeName;

    private RemoveTypeFieldDefinition removeFieldDefinition;

    private SetTypeDescription setDescription;

    public TypeUpdateAction build() {
      TypeUpdateAction result = new TypeUpdateAction();
      result.addEnumValue = this.addEnumValue;
      result.addFieldDefinition = this.addFieldDefinition;
      result.addLocalizedEnumValue = this.addLocalizedEnumValue;
      result.changeEnumValueLabel = this.changeEnumValueLabel;
      result.changeEnumValueOrder = this.changeEnumValueOrder;
      result.changeLabel = this.changeLabel;
      result.changeFieldDefinitionOrder = this.changeFieldDefinitionOrder;
      result.changeInputHint = this.changeInputHint;
      result.changeLocalizedEnumValueLabel = this.changeLocalizedEnumValueLabel;
      result.changeLocalizedEnumValueOrder = this.changeLocalizedEnumValueOrder;
      result.changeKey = this.changeKey;
      result.changeName = this.changeName;
      result.removeFieldDefinition = this.removeFieldDefinition;
      result.setDescription = this.setDescription;
      return result;
    }

    public Builder addEnumValue(AddTypeEnumValue addEnumValue) {
      this.addEnumValue = addEnumValue;
      return this;
    }

    public Builder addFieldDefinition(AddTypeFieldDefinition addFieldDefinition) {
      this.addFieldDefinition = addFieldDefinition;
      return this;
    }

    public Builder addLocalizedEnumValue(AddTypeLocalizedEnumValue addLocalizedEnumValue) {
      this.addLocalizedEnumValue = addLocalizedEnumValue;
      return this;
    }

    public Builder changeEnumValueLabel(ChangeTypeEnumValueLabel changeEnumValueLabel) {
      this.changeEnumValueLabel = changeEnumValueLabel;
      return this;
    }

    public Builder changeEnumValueOrder(ChangeTypeEnumValueOrder changeEnumValueOrder) {
      this.changeEnumValueOrder = changeEnumValueOrder;
      return this;
    }

    public Builder changeLabel(ChangeTypeLabel changeLabel) {
      this.changeLabel = changeLabel;
      return this;
    }

    public Builder changeFieldDefinitionOrder(
        ChangeTypeFieldDefinitionOrder changeFieldDefinitionOrder) {
      this.changeFieldDefinitionOrder = changeFieldDefinitionOrder;
      return this;
    }

    public Builder changeInputHint(ChangeTypeInputHint changeInputHint) {
      this.changeInputHint = changeInputHint;
      return this;
    }

    public Builder changeLocalizedEnumValueLabel(
        ChangeTypeLocalizedEnumValueLabel changeLocalizedEnumValueLabel) {
      this.changeLocalizedEnumValueLabel = changeLocalizedEnumValueLabel;
      return this;
    }

    public Builder changeLocalizedEnumValueOrder(
        ChangeTypeLocalizedEnumValueOrder changeLocalizedEnumValueOrder) {
      this.changeLocalizedEnumValueOrder = changeLocalizedEnumValueOrder;
      return this;
    }

    public Builder changeKey(ChangeTypeKey changeKey) {
      this.changeKey = changeKey;
      return this;
    }

    public Builder changeName(ChangeTypeName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder removeFieldDefinition(RemoveTypeFieldDefinition removeFieldDefinition) {
      this.removeFieldDefinition = removeFieldDefinition;
      return this;
    }

    public Builder setDescription(SetTypeDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }
  }
}
