package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class UpdateStagedOrderSyncInfo {
  private ResourceIdentifierInput channel;

  private OffsetDateTime syncedAt;

  private String externalId;

  public UpdateStagedOrderSyncInfo() {
  }

  public UpdateStagedOrderSyncInfo(ResourceIdentifierInput channel, OffsetDateTime syncedAt,
      String externalId) {
    this.channel = channel;
    this.syncedAt = syncedAt;
    this.externalId = externalId;
  }

  public ResourceIdentifierInput getChannel() {
    return channel;
  }

  public void setChannel(ResourceIdentifierInput channel) {
    this.channel = channel;
  }

  public OffsetDateTime getSyncedAt() {
    return syncedAt;
  }

  public void setSyncedAt(OffsetDateTime syncedAt) {
    this.syncedAt = syncedAt;
  }

  public String getExternalId() {
    return externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  @Override
  public String toString() {
    return "UpdateStagedOrderSyncInfo{channel='" + channel + "', syncedAt='" + syncedAt + "', externalId='" + externalId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UpdateStagedOrderSyncInfo that = (UpdateStagedOrderSyncInfo) o;
    return Objects.equals(channel, that.channel) &&
        Objects.equals(syncedAt, that.syncedAt) &&
        Objects.equals(externalId, that.externalId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(channel, syncedAt, externalId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput channel;

    private OffsetDateTime syncedAt;

    private String externalId;

    public UpdateStagedOrderSyncInfo build() {
      UpdateStagedOrderSyncInfo result = new UpdateStagedOrderSyncInfo();
      result.channel = this.channel;
      result.syncedAt = this.syncedAt;
      result.externalId = this.externalId;
      return result;
    }

    public Builder channel(ResourceIdentifierInput channel) {
      this.channel = channel;
      return this;
    }

    public Builder syncedAt(OffsetDateTime syncedAt) {
      this.syncedAt = syncedAt;
      return this;
    }

    public Builder externalId(String externalId) {
      this.externalId = externalId;
      return this;
    }
  }
}
