package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class VariantTailoring {
  private List<Image> images;

  private List<Asset> assets;

  public VariantTailoring() {
  }

  public VariantTailoring(List<Image> images, List<Asset> assets) {
    this.images = images;
    this.assets = assets;
  }

  public List<Image> getImages() {
    return images;
  }

  public void setImages(List<Image> images) {
    this.images = images;
  }

  public List<Asset> getAssets() {
    return assets;
  }

  public void setAssets(List<Asset> assets) {
    this.assets = assets;
  }

  @Override
  public String toString() {
    return "VariantTailoring{images='" + images + "', assets='" + assets + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VariantTailoring that = (VariantTailoring) o;
    return Objects.equals(images, that.images) &&
        Objects.equals(assets, that.assets);
  }

  @Override
  public int hashCode() {
    return Objects.hash(images, assets);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<Image> images;

    private List<Asset> assets;

    public VariantTailoring build() {
      VariantTailoring result = new VariantTailoring();
      result.images = this.images;
      result.assets = this.assets;
      return result;
    }

    public Builder images(List<Image> images) {
      this.images = images;
      return this;
    }

    public Builder assets(List<Asset> assets) {
      this.assets = assets;
      return this;
    }
  }
}
