package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.String;
import java.time.OffsetDateTime;

/**
 * Versioned object have an ID and version and modification. Every update of this object changes it's version.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = ApprovalFlow.class, name = "ApprovalFlow"),
    @JsonSubTypes.Type(value = ApprovalRule.class, name = "ApprovalRule"),
    @JsonSubTypes.Type(value = AssociateRole.class, name = "AssociateRole"),
    @JsonSubTypes.Type(value = AttributeGroup.class, name = "AttributeGroup"),
    @JsonSubTypes.Type(value = BusinessUnit.class, name = "BusinessUnit"),
    @JsonSubTypes.Type(value = Cart.class, name = "Cart"),
    @JsonSubTypes.Type(value = CartDiscount.class, name = "CartDiscount"),
    @JsonSubTypes.Type(value = Category.class, name = "Category"),
    @JsonSubTypes.Type(value = Channel.class, name = "Channel"),
    @JsonSubTypes.Type(value = CommercetoolsSubscription.class, name = "CommercetoolsSubscription"),
    @JsonSubTypes.Type(value = CustomObject.class, name = "CustomObject"),
    @JsonSubTypes.Type(value = Customer.class, name = "Customer"),
    @JsonSubTypes.Type(value = CustomerEmailToken.class, name = "CustomerEmailToken"),
    @JsonSubTypes.Type(value = CustomerGroup.class, name = "CustomerGroup"),
    @JsonSubTypes.Type(value = CustomerPasswordToken.class, name = "CustomerPasswordToken"),
    @JsonSubTypes.Type(value = DiscountCode.class, name = "DiscountCode"),
    @JsonSubTypes.Type(value = Extension.class, name = "Extension"),
    @JsonSubTypes.Type(value = InventoryEntry.class, name = "InventoryEntry"),
    @JsonSubTypes.Type(value = Message.class, name = "Message"),
    @JsonSubTypes.Type(value = Order.class, name = "Order"),
    @JsonSubTypes.Type(value = OrderEdit.class, name = "OrderEdit"),
    @JsonSubTypes.Type(value = Payment.class, name = "Payment"),
    @JsonSubTypes.Type(value = Product.class, name = "Product"),
    @JsonSubTypes.Type(value = ProductDiscount.class, name = "ProductDiscount"),
    @JsonSubTypes.Type(value = ProductSelection.class, name = "ProductSelection"),
    @JsonSubTypes.Type(value = ProductTailoring.class, name = "ProductTailoring"),
    @JsonSubTypes.Type(value = ProductTypeDefinition.class, name = "ProductTypeDefinition"),
    @JsonSubTypes.Type(value = Quote.class, name = "Quote"),
    @JsonSubTypes.Type(value = QuoteRequest.class, name = "QuoteRequest"),
    @JsonSubTypes.Type(value = Review.class, name = "Review"),
    @JsonSubTypes.Type(value = ShippingMethod.class, name = "ShippingMethod"),
    @JsonSubTypes.Type(value = ShoppingList.class, name = "ShoppingList"),
    @JsonSubTypes.Type(value = StagedQuote.class, name = "StagedQuote"),
    @JsonSubTypes.Type(value = StandalonePrice.class, name = "StandalonePrice"),
    @JsonSubTypes.Type(value = State.class, name = "State"),
    @JsonSubTypes.Type(value = Store.class, name = "Store"),
    @JsonSubTypes.Type(value = TaxCategory.class, name = "TaxCategory"),
    @JsonSubTypes.Type(value = TypeDefinition.class, name = "TypeDefinition"),
    @JsonSubTypes.Type(value = Zone.class, name = "Zone")
})
public interface Versioned {
  String getId();

  void setId(String id);

  Long getVersion();

  void setVersion(Long version);

  OffsetDateTime getCreatedAt();

  void setCreatedAt(OffsetDateTime createdAt);

  OffsetDateTime getLastModifiedAt();

  void setLastModifiedAt(OffsetDateTime lastModifiedAt);

  Initiator getCreatedBy();

  void setCreatedBy(Initiator createdBy);

  Initiator getLastModifiedBy();

  void setLastModifiedBy(Initiator lastModifiedBy);
}
