package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ZoneLimitsProjection {
  private ZoneLimitWithCurrent total;

  public ZoneLimitsProjection() {
  }

  public ZoneLimitsProjection(ZoneLimitWithCurrent total) {
    this.total = total;
  }

  public ZoneLimitWithCurrent getTotal() {
    return total;
  }

  public void setTotal(ZoneLimitWithCurrent total) {
    this.total = total;
  }

  @Override
  public String toString() {
    return "ZoneLimitsProjection{total='" + total + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ZoneLimitsProjection that = (ZoneLimitsProjection) o;
    return Objects.equals(total, that.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ZoneLimitWithCurrent total;

    public ZoneLimitsProjection build() {
      ZoneLimitsProjection result = new ZoneLimitsProjection();
      result.total = this.total;
      return result;
    }

    public Builder total(ZoneLimitWithCurrent total) {
      this.total = total;
      return this;
    }
  }
}
