package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ZoneRate {
  private List<ShippingRate> shippingRates;

  private Reference zoneRef;

  private Zone zone;

  public ZoneRate() {
  }

  public ZoneRate(List<ShippingRate> shippingRates, Reference zoneRef, Zone zone) {
    this.shippingRates = shippingRates;
    this.zoneRef = zoneRef;
    this.zone = zone;
  }

  public List<ShippingRate> getShippingRates() {
    return shippingRates;
  }

  public void setShippingRates(List<ShippingRate> shippingRates) {
    this.shippingRates = shippingRates;
  }

  public Reference getZoneRef() {
    return zoneRef;
  }

  public void setZoneRef(Reference zoneRef) {
    this.zoneRef = zoneRef;
  }

  public Zone getZone() {
    return zone;
  }

  public void setZone(Zone zone) {
    this.zone = zone;
  }

  @Override
  public String toString() {
    return "ZoneRate{shippingRates='" + shippingRates + "', zoneRef='" + zoneRef + "', zone='" + zone + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ZoneRate that = (ZoneRate) o;
    return Objects.equals(shippingRates, that.shippingRates) &&
        Objects.equals(zoneRef, that.zoneRef) &&
        Objects.equals(zone, that.zone);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingRates, zoneRef, zone);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ShippingRate> shippingRates;

    private Reference zoneRef;

    private Zone zone;

    public ZoneRate build() {
      ZoneRate result = new ZoneRate();
      result.shippingRates = this.shippingRates;
      result.zoneRef = this.zoneRef;
      result.zone = this.zone;
      return result;
    }

    public Builder shippingRates(List<ShippingRate> shippingRates) {
      this.shippingRates = shippingRates;
      return this;
    }

    public Builder zoneRef(Reference zoneRef) {
      this.zoneRef = zoneRef;
      return this;
    }

    public Builder zone(Zone zone) {
      this.zone = zone;
      return this;
    }
  }
}
