package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ZoneRateDraft {
  private ResourceIdentifierInput zone;

  private List<ShippingRateDraft> shippingRates = Collections.emptyList();

  public ZoneRateDraft() {
  }

  public ZoneRateDraft(ResourceIdentifierInput zone, List<ShippingRateDraft> shippingRates) {
    this.zone = zone;
    this.shippingRates = shippingRates;
  }

  public ResourceIdentifierInput getZone() {
    return zone;
  }

  public void setZone(ResourceIdentifierInput zone) {
    this.zone = zone;
  }

  public List<ShippingRateDraft> getShippingRates() {
    return shippingRates;
  }

  public void setShippingRates(List<ShippingRateDraft> shippingRates) {
    this.shippingRates = shippingRates;
  }

  @Override
  public String toString() {
    return "ZoneRateDraft{zone='" + zone + "', shippingRates='" + shippingRates + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ZoneRateDraft that = (ZoneRateDraft) o;
    return Objects.equals(zone, that.zone) &&
        Objects.equals(shippingRates, that.shippingRates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(zone, shippingRates);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput zone;

    private List<ShippingRateDraft> shippingRates = Collections.emptyList();

    public ZoneRateDraft build() {
      ZoneRateDraft result = new ZoneRateDraft();
      result.zone = this.zone;
      result.shippingRates = this.shippingRates;
      return result;
    }

    public Builder zone(ResourceIdentifierInput zone) {
      this.zone = zone;
      return this;
    }

    public Builder shippingRates(List<ShippingRateDraft> shippingRates) {
      this.shippingRates = shippingRates;
      return this;
    }
  }
}
