package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ZoneUpdateAction {
  private AddZoneLocation addLocation;

  private ChangeZoneName changeName;

  private RemoveZoneLocation removeLocation;

  private SetZoneDescription setDescription;

  private SetZoneKey setKey;

  public ZoneUpdateAction() {
  }

  public ZoneUpdateAction(AddZoneLocation addLocation, ChangeZoneName changeName,
      RemoveZoneLocation removeLocation, SetZoneDescription setDescription, SetZoneKey setKey) {
    this.addLocation = addLocation;
    this.changeName = changeName;
    this.removeLocation = removeLocation;
    this.setDescription = setDescription;
    this.setKey = setKey;
  }

  public AddZoneLocation getAddLocation() {
    return addLocation;
  }

  public void setAddLocation(AddZoneLocation addLocation) {
    this.addLocation = addLocation;
  }

  public ChangeZoneName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeZoneName changeName) {
    this.changeName = changeName;
  }

  public RemoveZoneLocation getRemoveLocation() {
    return removeLocation;
  }

  public void setRemoveLocation(RemoveZoneLocation removeLocation) {
    this.removeLocation = removeLocation;
  }

  public SetZoneDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(SetZoneDescription setDescription) {
    this.setDescription = setDescription;
  }

  public SetZoneKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetZoneKey setKey) {
    this.setKey = setKey;
  }

  @Override
  public String toString() {
    return "ZoneUpdateAction{addLocation='" + addLocation + "', changeName='" + changeName + "', removeLocation='" + removeLocation + "', setDescription='" + setDescription + "', setKey='" + setKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ZoneUpdateAction that = (ZoneUpdateAction) o;
    return Objects.equals(addLocation, that.addLocation) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(removeLocation, that.removeLocation) &&
        Objects.equals(setDescription, that.setDescription) &&
        Objects.equals(setKey, that.setKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addLocation, changeName, removeLocation, setDescription, setKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddZoneLocation addLocation;

    private ChangeZoneName changeName;

    private RemoveZoneLocation removeLocation;

    private SetZoneDescription setDescription;

    private SetZoneKey setKey;

    public ZoneUpdateAction build() {
      ZoneUpdateAction result = new ZoneUpdateAction();
      result.addLocation = this.addLocation;
      result.changeName = this.changeName;
      result.removeLocation = this.removeLocation;
      result.setDescription = this.setDescription;
      result.setKey = this.setKey;
      return result;
    }

    public Builder addLocation(AddZoneLocation addLocation) {
      this.addLocation = addLocation;
      return this;
    }

    public Builder changeName(ChangeZoneName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder removeLocation(RemoveZoneLocation removeLocation) {
      this.removeLocation = removeLocation;
      return this;
    }

    public Builder setDescription(SetZoneDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }

    public Builder setKey(SetZoneKey setKey) {
      this.setKey = setKey;
      return this;
    }
  }
}
