package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class addLocalizedEnumValue {
  private String attributeName;

  private LocalizedEnumValueDraft value;

  public addLocalizedEnumValue() {
  }

  public addLocalizedEnumValue(String attributeName, LocalizedEnumValueDraft value) {
    this.attributeName = attributeName;
    this.value = value;
  }

  public String getAttributeName() {
    return attributeName;
  }

  public void setAttributeName(String attributeName) {
    this.attributeName = attributeName;
  }

  public LocalizedEnumValueDraft getValue() {
    return value;
  }

  public void setValue(LocalizedEnumValueDraft value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "addLocalizedEnumValue{attributeName='" + attributeName + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    addLocalizedEnumValue that = (addLocalizedEnumValue) o;
    return Objects.equals(attributeName, that.attributeName) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributeName, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String attributeName;

    private LocalizedEnumValueDraft value;

    public addLocalizedEnumValue build() {
      addLocalizedEnumValue result = new addLocalizedEnumValue();
      result.attributeName = this.attributeName;
      result.value = this.value;
      return result;
    }

    public Builder attributeName(String attributeName) {
      this.attributeName = attributeName;
      return this;
    }

    public Builder value(LocalizedEnumValueDraft value) {
      this.value = value;
      return this;
    }
  }
}
