package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class addPlainEnumValue {
  private String attributeName;

  private PlainEnumValueDraft value;

  public addPlainEnumValue() {
  }

  public addPlainEnumValue(String attributeName, PlainEnumValueDraft value) {
    this.attributeName = attributeName;
    this.value = value;
  }

  public String getAttributeName() {
    return attributeName;
  }

  public void setAttributeName(String attributeName) {
    this.attributeName = attributeName;
  }

  public PlainEnumValueDraft getValue() {
    return value;
  }

  public void setValue(PlainEnumValueDraft value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "addPlainEnumValue{attributeName='" + attributeName + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    addPlainEnumValue that = (addPlainEnumValue) o;
    return Objects.equals(attributeName, that.attributeName) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributeName, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String attributeName;

    private PlainEnumValueDraft value;

    public addPlainEnumValue build() {
      addPlainEnumValue result = new addPlainEnumValue();
      result.attributeName = this.attributeName;
      result.value = this.value;
      return result;
    }

    public Builder attributeName(String attributeName) {
      this.attributeName = attributeName;
      return this;
    }

    public Builder value(PlainEnumValueDraft value) {
      this.value = value;
      return this;
    }
  }
}
