package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class changeAttributeName {
  private String attributeName;

  private String newAttributeName;

  public changeAttributeName() {
  }

  public changeAttributeName(String attributeName, String newAttributeName) {
    this.attributeName = attributeName;
    this.newAttributeName = newAttributeName;
  }

  public String getAttributeName() {
    return attributeName;
  }

  public void setAttributeName(String attributeName) {
    this.attributeName = attributeName;
  }

  public String getNewAttributeName() {
    return newAttributeName;
  }

  public void setNewAttributeName(String newAttributeName) {
    this.newAttributeName = newAttributeName;
  }

  @Override
  public String toString() {
    return "changeAttributeName{attributeName='" + attributeName + "', newAttributeName='" + newAttributeName + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    changeAttributeName that = (changeAttributeName) o;
    return Objects.equals(attributeName, that.attributeName) &&
        Objects.equals(newAttributeName, that.newAttributeName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributeName, newAttributeName);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String attributeName;

    private String newAttributeName;

    public changeAttributeName build() {
      changeAttributeName result = new changeAttributeName();
      result.attributeName = this.attributeName;
      result.newAttributeName = this.newAttributeName;
      return result;
    }

    public Builder attributeName(String attributeName) {
      this.attributeName = attributeName;
      return this;
    }

    public Builder newAttributeName(String newAttributeName) {
      this.newAttributeName = newAttributeName;
      return this;
    }
  }
}
