package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class changeInputHint {
  private String attributeName;

  private TextInputHint newValue;

  public changeInputHint() {
  }

  public changeInputHint(String attributeName, TextInputHint newValue) {
    this.attributeName = attributeName;
    this.newValue = newValue;
  }

  public String getAttributeName() {
    return attributeName;
  }

  public void setAttributeName(String attributeName) {
    this.attributeName = attributeName;
  }

  public TextInputHint getNewValue() {
    return newValue;
  }

  public void setNewValue(TextInputHint newValue) {
    this.newValue = newValue;
  }

  @Override
  public String toString() {
    return "changeInputHint{attributeName='" + attributeName + "', newValue='" + newValue + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    changeInputHint that = (changeInputHint) o;
    return Objects.equals(attributeName, that.attributeName) &&
        Objects.equals(newValue, that.newValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributeName, newValue);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String attributeName;

    private TextInputHint newValue;

    public changeInputHint build() {
      changeInputHint result = new changeInputHint();
      result.attributeName = this.attributeName;
      result.newValue = this.newValue;
      return result;
    }

    public Builder attributeName(String attributeName) {
      this.attributeName = attributeName;
      return this;
    }

    public Builder newValue(TextInputHint newValue) {
      this.newValue = newValue;
      return this;
    }
  }
}
