package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class changeLabel {
  private String attributeName;

  private List<LocalizedStringItemInputType> label;

  public changeLabel() {
  }

  public changeLabel(String attributeName, List<LocalizedStringItemInputType> label) {
    this.attributeName = attributeName;
    this.label = label;
  }

  public String getAttributeName() {
    return attributeName;
  }

  public void setAttributeName(String attributeName) {
    this.attributeName = attributeName;
  }

  public List<LocalizedStringItemInputType> getLabel() {
    return label;
  }

  public void setLabel(List<LocalizedStringItemInputType> label) {
    this.label = label;
  }

  @Override
  public String toString() {
    return "changeLabel{attributeName='" + attributeName + "', label='" + label + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    changeLabel that = (changeLabel) o;
    return Objects.equals(attributeName, that.attributeName) &&
        Objects.equals(label, that.label);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributeName, label);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String attributeName;

    private List<LocalizedStringItemInputType> label;

    public changeLabel build() {
      changeLabel result = new changeLabel();
      result.attributeName = this.attributeName;
      result.label = this.label;
      return result;
    }

    public Builder attributeName(String attributeName) {
      this.attributeName = attributeName;
      return this;
    }

    public Builder label(List<LocalizedStringItemInputType> label) {
      this.label = label;
      return this;
    }
  }
}
