package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class changeLocalizedEnumValueOrder {
  private String attributeName;

  private List<LocalizedEnumValueDraft> values;

  public changeLocalizedEnumValueOrder() {
  }

  public changeLocalizedEnumValueOrder(String attributeName, List<LocalizedEnumValueDraft> values) {
    this.attributeName = attributeName;
    this.values = values;
  }

  public String getAttributeName() {
    return attributeName;
  }

  public void setAttributeName(String attributeName) {
    this.attributeName = attributeName;
  }

  public List<LocalizedEnumValueDraft> getValues() {
    return values;
  }

  public void setValues(List<LocalizedEnumValueDraft> values) {
    this.values = values;
  }

  @Override
  public String toString() {
    return "changeLocalizedEnumValueOrder{attributeName='" + attributeName + "', values='" + values + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    changeLocalizedEnumValueOrder that = (changeLocalizedEnumValueOrder) o;
    return Objects.equals(attributeName, that.attributeName) &&
        Objects.equals(values, that.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributeName, values);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String attributeName;

    private List<LocalizedEnumValueDraft> values;

    public changeLocalizedEnumValueOrder build() {
      changeLocalizedEnumValueOrder result = new changeLocalizedEnumValueOrder();
      result.attributeName = this.attributeName;
      result.values = this.values;
      return result;
    }

    public Builder attributeName(String attributeName) {
      this.attributeName = attributeName;
      return this;
    }

    public Builder values(List<LocalizedEnumValueDraft> values) {
      this.values = values;
      return this;
    }
  }
}
