package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class setInputTip {
  private String attributeName;

  private List<LocalizedStringItemInputType> inputTip;

  public setInputTip() {
  }

  public setInputTip(String attributeName, List<LocalizedStringItemInputType> inputTip) {
    this.attributeName = attributeName;
    this.inputTip = inputTip;
  }

  public String getAttributeName() {
    return attributeName;
  }

  public void setAttributeName(String attributeName) {
    this.attributeName = attributeName;
  }

  public List<LocalizedStringItemInputType> getInputTip() {
    return inputTip;
  }

  public void setInputTip(List<LocalizedStringItemInputType> inputTip) {
    this.inputTip = inputTip;
  }

  @Override
  public String toString() {
    return "setInputTip{attributeName='" + attributeName + "', inputTip='" + inputTip + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    setInputTip that = (setInputTip) o;
    return Objects.equals(attributeName, that.attributeName) &&
        Objects.equals(inputTip, that.inputTip);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributeName, inputTip);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String attributeName;

    private List<LocalizedStringItemInputType> inputTip;

    public setInputTip build() {
      setInputTip result = new setInputTip();
      result.attributeName = this.attributeName;
      result.inputTip = this.inputTip;
      return result;
    }

    public Builder attributeName(String attributeName) {
      this.attributeName = attributeName;
      return this;
    }

    public Builder inputTip(List<LocalizedStringItemInputType> inputTip) {
      this.inputTip = inputTip;
      return this;
    }
  }
}
