/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.ProductPriceDataInput;
import java.util.Objects;

public class AddProductPrice {
    private Integer variantId;
    private String sku;
    private ProductPriceDataInput price;
    private Boolean staged = true;

    public AddProductPrice() {
    }

    public AddProductPrice(Integer variantId, String sku, ProductPriceDataInput price, Boolean staged) {
        this.variantId = variantId;
        this.sku = sku;
        this.price = price;
        this.staged = staged;
    }

    public Integer getVariantId() {
        return this.variantId;
    }

    public void setVariantId(Integer variantId) {
        this.variantId = variantId;
    }

    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public ProductPriceDataInput getPrice() {
        return this.price;
    }

    public void setPrice(ProductPriceDataInput price) {
        this.price = price;
    }

    public Boolean getStaged() {
        return this.staged;
    }

    public void setStaged(Boolean staged) {
        this.staged = staged;
    }

    public String toString() {
        return "AddProductPrice{variantId='" + this.variantId + "', sku='" + this.sku + "', price='" + this.price + "', staged='" + this.staged + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddProductPrice that = (AddProductPrice)o;
        return Objects.equals(this.variantId, that.variantId) && Objects.equals(this.sku, that.sku) && Objects.equals(this.price, that.price) && Objects.equals(this.staged, that.staged);
    }

    public int hashCode() {
        return Objects.hash(this.variantId, this.sku, this.price, this.staged);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Integer variantId;
        private String sku;
        private ProductPriceDataInput price;
        private Boolean staged = true;

        public AddProductPrice build() {
            AddProductPrice result = new AddProductPrice();
            result.variantId = this.variantId;
            result.sku = this.sku;
            result.price = this.price;
            result.staged = this.staged;
            return result;
        }

        public Builder variantId(Integer variantId) {
            this.variantId = variantId;
            return this;
        }

        public Builder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public Builder price(ProductPriceDataInput price) {
            this.price = price;
            return this;
        }

        public Builder staged(Boolean staged) {
            this.staged = staged;
            return this;
        }
    }
}

