/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Destination;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class ConfluentCloudDestination
implements Destination {
    private String bootstrapServer;
    private String apiKey;
    private String apiSecret;
    private String acks;
    private String topic;
    private String key;
    private String type;

    public ConfluentCloudDestination() {
    }

    public ConfluentCloudDestination(String bootstrapServer, String apiKey, String apiSecret, String acks, String topic, String key, String type) {
        this.bootstrapServer = bootstrapServer;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.acks = acks;
        this.topic = topic;
        this.key = key;
        this.type = type;
    }

    public String getBootstrapServer() {
        return this.bootstrapServer;
    }

    public void setBootstrapServer(String bootstrapServer) {
        this.bootstrapServer = bootstrapServer;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public String getAcks() {
        return this.acks;
    }

    public void setAcks(String acks) {
        this.acks = acks;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "ConfluentCloudDestination{bootstrapServer='" + this.bootstrapServer + "', apiKey='" + this.apiKey + "', apiSecret='" + this.apiSecret + "', acks='" + this.acks + "', topic='" + this.topic + "', key='" + this.key + "', type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfluentCloudDestination that = (ConfluentCloudDestination)o;
        return Objects.equals(this.bootstrapServer, that.bootstrapServer) && Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.apiSecret, that.apiSecret) && Objects.equals(this.acks, that.acks) && Objects.equals(this.topic, that.topic) && Objects.equals(this.key, that.key) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.bootstrapServer, this.apiKey, this.apiSecret, this.acks, this.topic, this.key, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String bootstrapServer;
        private String apiKey;
        private String apiSecret;
        private String acks;
        private String topic;
        private String key;
        private String type;

        public ConfluentCloudDestination build() {
            ConfluentCloudDestination result = new ConfluentCloudDestination();
            result.bootstrapServer = this.bootstrapServer;
            result.apiKey = this.apiKey;
            result.apiSecret = this.apiSecret;
            result.acks = this.acks;
            result.topic = this.topic;
            result.key = this.key;
            result.type = this.type;
            return result;
        }

        public Builder bootstrapServer(String bootstrapServer) {
            this.bootstrapServer = bootstrapServer;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiSecret(String apiSecret) {
            this.apiSecret = apiSecret;
            return this;
        }

        public Builder acks(String acks) {
            this.acks = acks;
            return this;
        }

        public Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

