/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.OrderMessagePayload;
import com.commercetools.graphql.api.types.Reference;
import com.commercetools.graphql.api.types.State;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class CustomLineItemStateTransition
implements MessagePayload,
OrderMessagePayload {
    private String customLineItemId;
    private String customLineItemKey;
    private OffsetDateTime transitionDate;
    private Long quantity;
    private State fromState;
    private State toState;
    private Reference fromStateRef;
    private Reference toStateRef;
    private String type;

    public CustomLineItemStateTransition() {
    }

    public CustomLineItemStateTransition(String customLineItemId, String customLineItemKey, OffsetDateTime transitionDate, Long quantity, State fromState, State toState, Reference fromStateRef, Reference toStateRef, String type) {
        this.customLineItemId = customLineItemId;
        this.customLineItemKey = customLineItemKey;
        this.transitionDate = transitionDate;
        this.quantity = quantity;
        this.fromState = fromState;
        this.toState = toState;
        this.fromStateRef = fromStateRef;
        this.toStateRef = toStateRef;
        this.type = type;
    }

    public String getCustomLineItemId() {
        return this.customLineItemId;
    }

    public void setCustomLineItemId(String customLineItemId) {
        this.customLineItemId = customLineItemId;
    }

    public String getCustomLineItemKey() {
        return this.customLineItemKey;
    }

    public void setCustomLineItemKey(String customLineItemKey) {
        this.customLineItemKey = customLineItemKey;
    }

    public OffsetDateTime getTransitionDate() {
        return this.transitionDate;
    }

    public void setTransitionDate(OffsetDateTime transitionDate) {
        this.transitionDate = transitionDate;
    }

    public Long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    public State getFromState() {
        return this.fromState;
    }

    public void setFromState(State fromState) {
        this.fromState = fromState;
    }

    public State getToState() {
        return this.toState;
    }

    public void setToState(State toState) {
        this.toState = toState;
    }

    public Reference getFromStateRef() {
        return this.fromStateRef;
    }

    public void setFromStateRef(Reference fromStateRef) {
        this.fromStateRef = fromStateRef;
    }

    public Reference getToStateRef() {
        return this.toStateRef;
    }

    public void setToStateRef(Reference toStateRef) {
        this.toStateRef = toStateRef;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "CustomLineItemStateTransition{customLineItemId='" + this.customLineItemId + "', customLineItemKey='" + this.customLineItemKey + "', transitionDate='" + this.transitionDate + "', quantity='" + this.quantity + "', fromState='" + this.fromState + "', toState='" + this.toState + "', fromStateRef='" + this.fromStateRef + "', toStateRef='" + this.toStateRef + "', type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomLineItemStateTransition that = (CustomLineItemStateTransition)o;
        return Objects.equals(this.customLineItemId, that.customLineItemId) && Objects.equals(this.customLineItemKey, that.customLineItemKey) && Objects.equals(this.transitionDate, that.transitionDate) && Objects.equals(this.quantity, that.quantity) && Objects.equals(this.fromState, that.fromState) && Objects.equals(this.toState, that.toState) && Objects.equals(this.fromStateRef, that.fromStateRef) && Objects.equals(this.toStateRef, that.toStateRef) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.customLineItemId, this.customLineItemKey, this.transitionDate, this.quantity, this.fromState, this.toState, this.fromStateRef, this.toStateRef, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String customLineItemId;
        private String customLineItemKey;
        private OffsetDateTime transitionDate;
        private Long quantity;
        private State fromState;
        private State toState;
        private Reference fromStateRef;
        private Reference toStateRef;
        private String type;

        public CustomLineItemStateTransition build() {
            CustomLineItemStateTransition result = new CustomLineItemStateTransition();
            result.customLineItemId = this.customLineItemId;
            result.customLineItemKey = this.customLineItemKey;
            result.transitionDate = this.transitionDate;
            result.quantity = this.quantity;
            result.fromState = this.fromState;
            result.toState = this.toState;
            result.fromStateRef = this.fromStateRef;
            result.toStateRef = this.toStateRef;
            result.type = this.type;
            return result;
        }

        public Builder customLineItemId(String customLineItemId) {
            this.customLineItemId = customLineItemId;
            return this;
        }

        public Builder customLineItemKey(String customLineItemKey) {
            this.customLineItemKey = customLineItemKey;
            return this;
        }

        public Builder transitionDate(OffsetDateTime transitionDate) {
            this.transitionDate = transitionDate;
            return this;
        }

        public Builder quantity(Long quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder fromState(State fromState) {
            this.fromState = fromState;
            return this;
        }

        public Builder toState(State toState) {
            this.toState = toState;
            return this;
        }

        public Builder fromStateRef(Reference fromStateRef) {
            this.fromStateRef = fromStateRef;
            return this;
        }

        public Builder toStateRef(Reference toStateRef) {
            this.toStateRef = toStateRef;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

