/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Attribute;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.LocalDate;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class DateAttribute
implements Attribute {
    private LocalDate value;
    private String name;

    public DateAttribute() {
    }

    public DateAttribute(LocalDate value, String name) {
        this.value = value;
        this.name = name;
    }

    public LocalDate getValue() {
        return this.value;
    }

    public void setValue(LocalDate value) {
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "DateAttribute{value='" + this.value + "', name='" + this.name + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateAttribute that = (DateAttribute)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.name);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private LocalDate value;
        private String name;

        public DateAttribute build() {
            DateAttribute result = new DateAttribute();
            result.value = this.value;
            result.name = this.name;
            return result;
        }

        public Builder value(LocalDate value) {
            this.value = value;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }
    }
}

