/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.DiscountedLineItemPriceForQuantity;
import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.MethodTaxedPrice;
import com.commercetools.graphql.api.types.Money;
import com.commercetools.graphql.api.types.OrderMessagePayload;
import com.commercetools.graphql.api.types.TaxedItemPrice;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class OrderLineItemDiscountSet
implements MessagePayload,
OrderMessagePayload {
    private String lineItemId;
    private String lineItemKey;
    private List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity;
    private Money totalPrice;
    private List<MethodTaxedPrice> taxedPricePortions;
    private TaxedItemPrice taxedPrice;
    private String type;

    public OrderLineItemDiscountSet() {
    }

    public OrderLineItemDiscountSet(String lineItemId, String lineItemKey, List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity, Money totalPrice, List<MethodTaxedPrice> taxedPricePortions, TaxedItemPrice taxedPrice, String type) {
        this.lineItemId = lineItemId;
        this.lineItemKey = lineItemKey;
        this.discountedPricePerQuantity = discountedPricePerQuantity;
        this.totalPrice = totalPrice;
        this.taxedPricePortions = taxedPricePortions;
        this.taxedPrice = taxedPrice;
        this.type = type;
    }

    public String getLineItemId() {
        return this.lineItemId;
    }

    public void setLineItemId(String lineItemId) {
        this.lineItemId = lineItemId;
    }

    public String getLineItemKey() {
        return this.lineItemKey;
    }

    public void setLineItemKey(String lineItemKey) {
        this.lineItemKey = lineItemKey;
    }

    public List<DiscountedLineItemPriceForQuantity> getDiscountedPricePerQuantity() {
        return this.discountedPricePerQuantity;
    }

    public void setDiscountedPricePerQuantity(List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity) {
        this.discountedPricePerQuantity = discountedPricePerQuantity;
    }

    public Money getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(Money totalPrice) {
        this.totalPrice = totalPrice;
    }

    public List<MethodTaxedPrice> getTaxedPricePortions() {
        return this.taxedPricePortions;
    }

    public void setTaxedPricePortions(List<MethodTaxedPrice> taxedPricePortions) {
        this.taxedPricePortions = taxedPricePortions;
    }

    public TaxedItemPrice getTaxedPrice() {
        return this.taxedPrice;
    }

    public void setTaxedPrice(TaxedItemPrice taxedPrice) {
        this.taxedPrice = taxedPrice;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "OrderLineItemDiscountSet{lineItemId='" + this.lineItemId + "', lineItemKey='" + this.lineItemKey + "', discountedPricePerQuantity='" + this.discountedPricePerQuantity + "', totalPrice='" + this.totalPrice + "', taxedPricePortions='" + this.taxedPricePortions + "', taxedPrice='" + this.taxedPrice + "', type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderLineItemDiscountSet that = (OrderLineItemDiscountSet)o;
        return Objects.equals(this.lineItemId, that.lineItemId) && Objects.equals(this.lineItemKey, that.lineItemKey) && Objects.equals(this.discountedPricePerQuantity, that.discountedPricePerQuantity) && Objects.equals(this.totalPrice, that.totalPrice) && Objects.equals(this.taxedPricePortions, that.taxedPricePortions) && Objects.equals(this.taxedPrice, that.taxedPrice) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.lineItemId, this.lineItemKey, this.discountedPricePerQuantity, this.totalPrice, this.taxedPricePortions, this.taxedPrice, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String lineItemId;
        private String lineItemKey;
        private List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity;
        private Money totalPrice;
        private List<MethodTaxedPrice> taxedPricePortions;
        private TaxedItemPrice taxedPrice;
        private String type;

        public OrderLineItemDiscountSet build() {
            OrderLineItemDiscountSet result = new OrderLineItemDiscountSet();
            result.lineItemId = this.lineItemId;
            result.lineItemKey = this.lineItemKey;
            result.discountedPricePerQuantity = this.discountedPricePerQuantity;
            result.totalPrice = this.totalPrice;
            result.taxedPricePortions = this.taxedPricePortions;
            result.taxedPrice = this.taxedPrice;
            result.type = this.type;
            return result;
        }

        public Builder lineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
            return this;
        }

        public Builder lineItemKey(String lineItemKey) {
            this.lineItemKey = lineItemKey;
            return this;
        }

        public Builder discountedPricePerQuantity(List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity) {
            this.discountedPricePerQuantity = discountedPricePerQuantity;
            return this;
        }

        public Builder totalPrice(Money totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        public Builder taxedPricePortions(List<MethodTaxedPrice> taxedPricePortions) {
            this.taxedPricePortions = taxedPricePortions;
            return this;
        }

        public Builder taxedPrice(TaxedItemPrice taxedPrice) {
            this.taxedPrice = taxedPrice;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

