/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.KeyReference;
import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.OrderMessagePayload;
import com.commercetools.graphql.api.types.Store;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class OrderStoreSet
implements MessagePayload,
OrderMessagePayload {
    private Store store;
    private Store oldStore;
    private KeyReference storeRef;
    private KeyReference oldStoreRef;
    private String type;

    public OrderStoreSet() {
    }

    public OrderStoreSet(Store store, Store oldStore, KeyReference storeRef, KeyReference oldStoreRef, String type) {
        this.store = store;
        this.oldStore = oldStore;
        this.storeRef = storeRef;
        this.oldStoreRef = oldStoreRef;
        this.type = type;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public Store getOldStore() {
        return this.oldStore;
    }

    public void setOldStore(Store oldStore) {
        this.oldStore = oldStore;
    }

    public KeyReference getStoreRef() {
        return this.storeRef;
    }

    public void setStoreRef(KeyReference storeRef) {
        this.storeRef = storeRef;
    }

    public KeyReference getOldStoreRef() {
        return this.oldStoreRef;
    }

    public void setOldStoreRef(KeyReference oldStoreRef) {
        this.oldStoreRef = oldStoreRef;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "OrderStoreSet{store='" + this.store + "', oldStore='" + this.oldStore + "', storeRef='" + this.storeRef + "', oldStoreRef='" + this.oldStoreRef + "', type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderStoreSet that = (OrderStoreSet)o;
        return Objects.equals(this.store, that.store) && Objects.equals(this.oldStore, that.oldStore) && Objects.equals(this.storeRef, that.storeRef) && Objects.equals(this.oldStoreRef, that.oldStoreRef) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.store, this.oldStore, this.storeRef, this.oldStoreRef, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Store store;
        private Store oldStore;
        private KeyReference storeRef;
        private KeyReference oldStoreRef;
        private String type;

        public OrderStoreSet build() {
            OrderStoreSet result = new OrderStoreSet();
            result.store = this.store;
            result.oldStore = this.oldStore;
            result.storeRef = this.storeRef;
            result.oldStoreRef = this.oldStoreRef;
            result.type = this.type;
            return result;
        }

        public Builder store(Store store) {
            this.store = store;
            return this;
        }

        public Builder oldStore(Store oldStore) {
            this.oldStore = oldStore;
            return this;
        }

        public Builder storeRef(KeyReference storeRef) {
            this.storeRef = storeRef;
            return this;
        }

        public Builder oldStoreRef(KeyReference oldStoreRef) {
            this.oldStoreRef = oldStoreRef;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

