/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.CustomFieldsCommand;
import com.commercetools.graphql.api.types.DeliveryItem;
import com.commercetools.graphql.api.types.ParcelMeasurements;
import com.commercetools.graphql.api.types.TrackingData;
import java.util.List;
import java.util.Objects;

public class ParcelData {
    private String key;
    private ParcelMeasurements measurements;
    private TrackingData trackingData;
    private List<DeliveryItem> items;
    private CustomFieldsCommand custom;

    public ParcelData() {
    }

    public ParcelData(String key, ParcelMeasurements measurements, TrackingData trackingData, List<DeliveryItem> items, CustomFieldsCommand custom) {
        this.key = key;
        this.measurements = measurements;
        this.trackingData = trackingData;
        this.items = items;
        this.custom = custom;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ParcelMeasurements getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(ParcelMeasurements measurements) {
        this.measurements = measurements;
    }

    public TrackingData getTrackingData() {
        return this.trackingData;
    }

    public void setTrackingData(TrackingData trackingData) {
        this.trackingData = trackingData;
    }

    public List<DeliveryItem> getItems() {
        return this.items;
    }

    public void setItems(List<DeliveryItem> items) {
        this.items = items;
    }

    public CustomFieldsCommand getCustom() {
        return this.custom;
    }

    public void setCustom(CustomFieldsCommand custom) {
        this.custom = custom;
    }

    public String toString() {
        return "ParcelData{key='" + this.key + "', measurements='" + this.measurements + "', trackingData='" + this.trackingData + "', items='" + this.items + "', custom='" + this.custom + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParcelData that = (ParcelData)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.measurements, that.measurements) && Objects.equals(this.trackingData, that.trackingData) && Objects.equals(this.items, that.items) && Objects.equals(this.custom, that.custom);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.measurements, this.trackingData, this.items, this.custom);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String key;
        private ParcelMeasurements measurements;
        private TrackingData trackingData;
        private List<DeliveryItem> items;
        private CustomFieldsCommand custom;

        public ParcelData build() {
            ParcelData result = new ParcelData();
            result.key = this.key;
            result.measurements = this.measurements;
            result.trackingData = this.trackingData;
            result.items = this.items;
            result.custom = this.custom;
            return result;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder measurements(ParcelMeasurements measurements) {
            this.measurements = measurements;
            return this;
        }

        public Builder trackingData(TrackingData trackingData) {
            this.trackingData = trackingData;
            return this;
        }

        public Builder items(List<DeliveryItem> items) {
            this.items = items;
            return this;
        }

        public Builder custom(CustomFieldsCommand custom) {
            this.custom = custom;
            return this;
        }
    }
}

