/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.CustomFieldsDraft;
import com.commercetools.graphql.api.types.DeliveryItemDraftType;
import com.commercetools.graphql.api.types.ParcelMeasurementsDraftType;
import com.commercetools.graphql.api.types.TrackingDataDraftType;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ParcelDraft {
    private String id;
    private String key;
    private OffsetDateTime createdAt;
    private ParcelMeasurementsDraftType measurements;
    private TrackingDataDraftType trackingData;
    private List<DeliveryItemDraftType> items = Collections.emptyList();
    private CustomFieldsDraft custom;

    public ParcelDraft() {
    }

    public ParcelDraft(String id, String key, OffsetDateTime createdAt, ParcelMeasurementsDraftType measurements, TrackingDataDraftType trackingData, List<DeliveryItemDraftType> items, CustomFieldsDraft custom) {
        this.id = id;
        this.key = key;
        this.createdAt = createdAt;
        this.measurements = measurements;
        this.trackingData = trackingData;
        this.items = items;
        this.custom = custom;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public ParcelMeasurementsDraftType getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(ParcelMeasurementsDraftType measurements) {
        this.measurements = measurements;
    }

    public TrackingDataDraftType getTrackingData() {
        return this.trackingData;
    }

    public void setTrackingData(TrackingDataDraftType trackingData) {
        this.trackingData = trackingData;
    }

    public List<DeliveryItemDraftType> getItems() {
        return this.items;
    }

    public void setItems(List<DeliveryItemDraftType> items) {
        this.items = items;
    }

    public CustomFieldsDraft getCustom() {
        return this.custom;
    }

    public void setCustom(CustomFieldsDraft custom) {
        this.custom = custom;
    }

    public String toString() {
        return "ParcelDraft{id='" + this.id + "', key='" + this.key + "', createdAt='" + this.createdAt + "', measurements='" + this.measurements + "', trackingData='" + this.trackingData + "', items='" + this.items + "', custom='" + this.custom + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParcelDraft that = (ParcelDraft)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.key, that.key) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.measurements, that.measurements) && Objects.equals(this.trackingData, that.trackingData) && Objects.equals(this.items, that.items) && Objects.equals(this.custom, that.custom);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.key, this.createdAt, this.measurements, this.trackingData, this.items, this.custom);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private String key;
        private OffsetDateTime createdAt;
        private ParcelMeasurementsDraftType measurements;
        private TrackingDataDraftType trackingData;
        private List<DeliveryItemDraftType> items = Collections.emptyList();
        private CustomFieldsDraft custom;

        public ParcelDraft build() {
            ParcelDraft result = new ParcelDraft();
            result.id = this.id;
            result.key = this.key;
            result.createdAt = this.createdAt;
            result.measurements = this.measurements;
            result.trackingData = this.trackingData;
            result.items = this.items;
            result.custom = this.custom;
            return result;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder measurements(ParcelMeasurementsDraftType measurements) {
            this.measurements = measurements;
            return this;
        }

        public Builder trackingData(TrackingDataDraftType trackingData) {
            this.trackingData = trackingData;
            return this;
        }

        public Builder items(List<DeliveryItemDraftType> items) {
            this.items = items;
            return this;
        }

        public Builder custom(CustomFieldsDraft custom) {
            this.custom = custom;
            return this;
        }
    }
}

