/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.OrderMessagePayload;
import com.commercetools.graphql.api.types.Parcel;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class ParcelRemovedFromDelivery
implements MessagePayload,
OrderMessagePayload {
    private String deliveryId;
    private Parcel parcel;
    private String shippingKey;
    private String type;

    public ParcelRemovedFromDelivery() {
    }

    public ParcelRemovedFromDelivery(String deliveryId, Parcel parcel, String shippingKey, String type) {
        this.deliveryId = deliveryId;
        this.parcel = parcel;
        this.shippingKey = shippingKey;
        this.type = type;
    }

    public String getDeliveryId() {
        return this.deliveryId;
    }

    public void setDeliveryId(String deliveryId) {
        this.deliveryId = deliveryId;
    }

    public Parcel getParcel() {
        return this.parcel;
    }

    public void setParcel(Parcel parcel) {
        this.parcel = parcel;
    }

    public String getShippingKey() {
        return this.shippingKey;
    }

    public void setShippingKey(String shippingKey) {
        this.shippingKey = shippingKey;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "ParcelRemovedFromDelivery{deliveryId='" + this.deliveryId + "', parcel='" + this.parcel + "', shippingKey='" + this.shippingKey + "', type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParcelRemovedFromDelivery that = (ParcelRemovedFromDelivery)o;
        return Objects.equals(this.deliveryId, that.deliveryId) && Objects.equals(this.parcel, that.parcel) && Objects.equals(this.shippingKey, that.shippingKey) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.deliveryId, this.parcel, this.shippingKey, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String deliveryId;
        private Parcel parcel;
        private String shippingKey;
        private String type;

        public ParcelRemovedFromDelivery build() {
            ParcelRemovedFromDelivery result = new ParcelRemovedFromDelivery();
            result.deliveryId = this.deliveryId;
            result.parcel = this.parcel;
            result.shippingKey = this.shippingKey;
            result.type = this.type;
            return result;
        }

        public Builder deliveryId(String deliveryId) {
            this.deliveryId = deliveryId;
            return this;
        }

        public Builder parcel(Parcel parcel) {
            this.parcel = parcel;
            return this;
        }

        public Builder shippingKey(String shippingKey) {
            this.shippingKey = shippingKey;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

