/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.MoneyDraft;
import com.commercetools.graphql.api.types.ShippingRatePriceTierDraft;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ShippingRateDraft {
    private MoneyDraft price;
    private MoneyDraft freeAbove;
    private List<ShippingRatePriceTierDraft> tiers = Collections.emptyList();

    public ShippingRateDraft() {
    }

    public ShippingRateDraft(MoneyDraft price, MoneyDraft freeAbove, List<ShippingRatePriceTierDraft> tiers) {
        this.price = price;
        this.freeAbove = freeAbove;
        this.tiers = tiers;
    }

    public MoneyDraft getPrice() {
        return this.price;
    }

    public void setPrice(MoneyDraft price) {
        this.price = price;
    }

    public MoneyDraft getFreeAbove() {
        return this.freeAbove;
    }

    public void setFreeAbove(MoneyDraft freeAbove) {
        this.freeAbove = freeAbove;
    }

    public List<ShippingRatePriceTierDraft> getTiers() {
        return this.tiers;
    }

    public void setTiers(List<ShippingRatePriceTierDraft> tiers) {
        this.tiers = tiers;
    }

    public String toString() {
        return "ShippingRateDraft{price='" + this.price + "', freeAbove='" + this.freeAbove + "', tiers='" + this.tiers + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShippingRateDraft that = (ShippingRateDraft)o;
        return Objects.equals(this.price, that.price) && Objects.equals(this.freeAbove, that.freeAbove) && Objects.equals(this.tiers, that.tiers);
    }

    public int hashCode() {
        return Objects.hash(this.price, this.freeAbove, this.tiers);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private MoneyDraft price;
        private MoneyDraft freeAbove;
        private List<ShippingRatePriceTierDraft> tiers = Collections.emptyList();

        public ShippingRateDraft build() {
            ShippingRateDraft result = new ShippingRateDraft();
            result.price = this.price;
            result.freeAbove = this.freeAbove;
            result.tiers = this.tiers;
            return result;
        }

        public Builder price(MoneyDraft price) {
            this.price = price;
            return this;
        }

        public Builder freeAbove(MoneyDraft freeAbove) {
            this.freeAbove = freeAbove;
            return this;
        }

        public Builder tiers(List<ShippingRatePriceTierDraft> tiers) {
            this.tiers = tiers;
            return this;
        }
    }
}

