/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.CustomFieldsDraft;
import java.time.OffsetDateTime;
import java.util.Objects;

public class ShoppingListLineItemDraft {
    private String productId;
    private String key;
    private String sku;
    private Integer variantId;
    private Integer quantity = 1;
    private CustomFieldsDraft custom;
    private OffsetDateTime addedAt;

    public ShoppingListLineItemDraft() {
    }

    public ShoppingListLineItemDraft(String productId, String key, String sku, Integer variantId, Integer quantity, CustomFieldsDraft custom, OffsetDateTime addedAt) {
        this.productId = productId;
        this.key = key;
        this.sku = sku;
        this.variantId = variantId;
        this.quantity = quantity;
        this.custom = custom;
        this.addedAt = addedAt;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public Integer getVariantId() {
        return this.variantId;
    }

    public void setVariantId(Integer variantId) {
        this.variantId = variantId;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public CustomFieldsDraft getCustom() {
        return this.custom;
    }

    public void setCustom(CustomFieldsDraft custom) {
        this.custom = custom;
    }

    public OffsetDateTime getAddedAt() {
        return this.addedAt;
    }

    public void setAddedAt(OffsetDateTime addedAt) {
        this.addedAt = addedAt;
    }

    public String toString() {
        return "ShoppingListLineItemDraft{productId='" + this.productId + "', key='" + this.key + "', sku='" + this.sku + "', variantId='" + this.variantId + "', quantity='" + this.quantity + "', custom='" + this.custom + "', addedAt='" + this.addedAt + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShoppingListLineItemDraft that = (ShoppingListLineItemDraft)o;
        return Objects.equals(this.productId, that.productId) && Objects.equals(this.key, that.key) && Objects.equals(this.sku, that.sku) && Objects.equals(this.variantId, that.variantId) && Objects.equals(this.quantity, that.quantity) && Objects.equals(this.custom, that.custom) && Objects.equals(this.addedAt, that.addedAt);
    }

    public int hashCode() {
        return Objects.hash(this.productId, this.key, this.sku, this.variantId, this.quantity, this.custom, this.addedAt);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String productId;
        private String key;
        private String sku;
        private Integer variantId;
        private Integer quantity = 1;
        private CustomFieldsDraft custom;
        private OffsetDateTime addedAt;

        public ShoppingListLineItemDraft build() {
            ShoppingListLineItemDraft result = new ShoppingListLineItemDraft();
            result.productId = this.productId;
            result.key = this.key;
            result.sku = this.sku;
            result.variantId = this.variantId;
            result.quantity = this.quantity;
            result.custom = this.custom;
            result.addedAt = this.addedAt;
            return result;
        }

        public Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public Builder variantId(Integer variantId) {
            this.variantId = variantId;
            return this;
        }

        public Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder custom(CustomFieldsDraft custom) {
            this.custom = custom;
            return this;
        }

        public Builder addedAt(OffsetDateTime addedAt) {
            this.addedAt = addedAt;
            return this;
        }
    }
}

