/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.compat;

import com.commercetools.compat.CompatRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import io.sphere.sdk.client.SphereRequest;
import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.ClientRequestCommand;
import io.vrap.rmf.base.client.ResponseSerializer;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class CompatClient
implements ApiHttpClient {
    private final ApiHttpClient client;
    private final String projectKey;

    private CompatClient(ApiHttpClient client, String projectKey) {
        this.client = client;
        this.projectKey = projectKey;
    }

    public URI getBaseUri() {
        return this.client.getBaseUri();
    }

    public static CompatClient of(ApiHttpClient client, String projectKey) {
        return new CompatClient(client, projectKey);
    }

    public <O, TO> CompletableFuture<ApiHttpResponse<O>> execute(SphereRequest<TO> request, Class<O> outputType) {
        CompatRequest<O> compatRequest = CompatRequest.of(this.client, this.projectKey, request, outputType);
        return compatRequest.execute(this.client);
    }

    public <O, TO> ApiHttpResponse<O> executeBlocking(SphereRequest<TO> request, Class<O> outputType) {
        CompatRequest<O> compatRequest = CompatRequest.of(this.client, this.projectKey, request, outputType);
        return compatRequest.executeBlocking(this.client);
    }

    public <O, TO> ApiHttpResponse<O> executeBlocking(SphereRequest<TO> request, Class<O> outputType, Duration duration) {
        CompatRequest<O> compatRequest = CompatRequest.of(this.client, this.projectKey, request, outputType);
        return compatRequest.executeBlocking(this.client, duration);
    }

    public <O> CompletableFuture<ApiHttpResponse<O>> execute(ApiHttpRequest request, Class<O> outputType) {
        return this.client.execute(request, outputType);
    }

    public <O> CompletableFuture<ApiHttpResponse<O>> execute(ApiHttpRequest request, TypeReference<O> outputType) {
        return this.client.execute(request, outputType);
    }

    public <O> CompletableFuture<ApiHttpResponse<O>> execute(ApiHttpRequest request, JavaType outputType) {
        return this.client.execute(request, outputType);
    }

    public <O> CompletableFuture<ApiHttpResponse<O>> execute(ClientRequestCommand<O> method) {
        return method.execute((ApiHttpClient)this);
    }

    public ResponseSerializer getSerializerService() {
        return this.client.getSerializerService();
    }

    public CompletableFuture<ApiHttpResponse<byte[]>> execute(ApiHttpRequest request) {
        return this.client.execute(request);
    }

    public void close() throws Exception {
        this.client.close();
    }
}

