/*
 * Decompiled with CFR 0.152.
 */
package io.sphere.sdk.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.sphere.sdk.client.BadGatewayException;
import io.sphere.sdk.client.ConcurrentModificationException;
import io.sphere.sdk.client.ErrorResponseException;
import io.sphere.sdk.client.ForbiddenException;
import io.sphere.sdk.client.GatewayTimeoutException;
import io.sphere.sdk.client.HttpResponseBodyUtils;
import io.sphere.sdk.client.HttpResponseExceptionResponsibility;
import io.sphere.sdk.client.InternalServerErrorException;
import io.sphere.sdk.client.InvalidTokenException;
import io.sphere.sdk.client.NotFoundException;
import io.sphere.sdk.client.RequestEntityTooLargeException;
import io.sphere.sdk.client.ServiceUnavailableException;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.client.UnauthorizedException;
import io.sphere.sdk.http.HttpResponse;
import io.sphere.sdk.json.SphereJsonUtils;
import io.sphere.sdk.models.SphereException;
import io.sphere.sdk.models.errors.ErrorResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class CompatExceptionFactory {
    private final List<HttpResponseExceptionResponsibility> responsibilities = new ArrayList<HttpResponseExceptionResponsibility>();

    CompatExceptionFactory() {
    }

    private CompatExceptionFactory when(Predicate<HttpResponse> predicate, Function<HttpResponse, SphereException> exceptionCreator) {
        return this.addResponsibility(predicate, exceptionCreator);
    }

    private CompatExceptionFactory addResponsibility(Predicate<HttpResponse> predicate, Function<HttpResponse, SphereException> exceptionCreator) {
        HttpResponseExceptionResponsibility r = new HttpResponseExceptionResponsibility(predicate, exceptionCreator);
        this.responsibilities.add(r);
        return this;
    }

    private CompatExceptionFactory whenStatus(int status, Function<HttpResponse, SphereException> exceptionCreator) {
        return this.addResponsibility(response -> response.getStatusCode() == status, response -> (SphereException)exceptionCreator.apply((HttpResponse)response));
    }

    private static String extractBody(HttpResponse httpResponse) {
        return Optional.ofNullable(httpResponse.getResponseBody()).map(b -> HttpResponseBodyUtils.bytesToString((byte[])b)).orElse("");
    }

    public static CompatExceptionFactory of() {
        CompatExceptionFactory exceptionFactory = new CompatExceptionFactory().when(r -> CompatExceptionFactory.isServiceNotAvailable(r), r -> new ServiceUnavailableException(CompatExceptionFactory.extractBody(r))).whenStatus(401, r -> {
            String body = CompatExceptionFactory.extractBody(r);
            return body.contains("invalid_token") ? new InvalidTokenException() : new UnauthorizedException(body, 401);
        }).whenStatus(403, r -> new ForbiddenException(CompatExceptionFactory.extractBody(r))).whenStatus(500, r -> new InternalServerErrorException(CompatExceptionFactory.extractBody(r))).whenStatus(502, r -> new BadGatewayException(CompatExceptionFactory.extractBody(r))).whenStatus(503, r -> new ServiceUnavailableException(CompatExceptionFactory.extractBody(r))).whenStatus(504, r -> new GatewayTimeoutException(CompatExceptionFactory.extractBody(r))).whenStatus(409, r -> {
            ErrorResponse errorResponse = (ErrorResponse)SphereJsonUtils.readObject((byte[])r.getResponseBody(), (TypeReference)ErrorResponse.typeReference());
            return new ConcurrentModificationException(errorResponse);
        }).whenStatus(413, r -> new RequestEntityTooLargeException()).whenStatus(400, r -> {
            String body = CompatExceptionFactory.extractBody(r);
            if (body.contains("invalid_scope")) {
                return new InvalidTokenException();
            }
            ErrorResponse errorResponse = (ErrorResponse)SphereJsonUtils.readObject((byte[])r.getResponseBody(), (TypeReference)ErrorResponse.typeReference());
            return new ErrorResponseException(errorResponse);
        }).whenStatus(404, r -> new NotFoundException()).when(response -> true, r -> new SphereException("Can't parse backend response."));
        return exceptionFactory;
    }

    private static boolean isServiceNotAvailable(HttpResponse httpResponse) {
        return httpResponse.getStatusCode() == 503 || Optional.ofNullable(httpResponse.getResponseBody()).map(b -> HttpResponseBodyUtils.bytesToString((byte[])b)).map(s -> s.contains("<h2>Service Unavailable</h2>")).orElse(false) != false;
    }

    public <T> SphereException createException(HttpResponse httpResponse, SphereRequest<T> sphereRequest, ObjectMapper objectMapper) {
        HttpResponseExceptionResponsibility responsibility = this.responsibilities.stream().filter(x -> x.getPredicate().test(httpResponse)).findFirst().get();
        return (SphereException)responsibility.getExceptionCreator().apply(httpResponse);
    }
}

