/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.compat;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.defaultconfig.ApiRootBuilder;
import com.commercetools.compat.CompatRequest;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.sphere.sdk.client.CompatExceptionFactory;
import io.sphere.sdk.client.CorrelationIdGenerator;
import io.sphere.sdk.client.SphereApiConfig;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.client.SphereClientConfig;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.http.HttpHeaders;
import io.sphere.sdk.http.HttpRequest;
import io.sphere.sdk.http.HttpResponse;
import io.sphere.sdk.json.JsonException;
import io.sphere.sdk.json.SphereJsonUtils;
import io.sphere.sdk.models.SphereException;
import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.ApiHttpException;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.AutoCloseableService;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.oauth2.ClientCredentials;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;

public class CompatSphereClient
extends AutoCloseableService
implements SphereClient {
    private final ApiHttpClient client;
    private final String projectKey;
    private final ObjectMapper mapper;
    private final ExceptionMode exceptionMode;

    private CompatSphereClient(ApiHttpClient apiHttpClient, ObjectMapper mapper, String projectKey, ExceptionMode exceptionMode) {
        this.projectKey = projectKey;
        this.mapper = mapper;
        this.client = new CompatApiHttpClient(apiHttpClient, mapper);
        this.exceptionMode = exceptionMode;
    }

    public ProjectApiRoot apiRoot() {
        return ProjectApiRoot.fromClient((String)this.projectKey, (ApiHttpClient)this.client);
    }

    public ApiHttpClient getClient() {
        return this.client;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public ExceptionMode getExceptionMode() {
        return this.exceptionMode;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public static CompatSphereClient of(SphereClientConfig clientConfig) {
        return CompatSphereClient.of(CompatSphereClient.createDefaultClient(clientConfig), SphereJsonUtils.newObjectMapper(), clientConfig.getProjectKey(), ExceptionMode.SDK_V2);
    }

    public static CompatSphereClient of(ProjectApiRoot apiRoot) {
        return CompatSphereClient.of(apiRoot.getApiHttpClient(), SphereJsonUtils.newObjectMapper(), apiRoot.getProjectKey(), ExceptionMode.SDK_V1);
    }

    public static CompatSphereClient of(ProjectApiRoot apiRoot, ObjectMapper mapper) {
        return CompatSphereClient.of(apiRoot.getApiHttpClient(), mapper, apiRoot.getProjectKey(), ExceptionMode.SDK_V1);
    }

    public static CompatSphereClient of(ApiHttpClient apiHttpClient, String projectKey) {
        return CompatSphereClient.of(apiHttpClient, SphereJsonUtils.newObjectMapper(), projectKey, ExceptionMode.SDK_V1);
    }

    public static CompatSphereClient of(ApiHttpClient apiHttpClient, ObjectMapper mapper, String projectKey) {
        return CompatSphereClient.of(apiHttpClient, mapper, projectKey, ExceptionMode.SDK_V1);
    }

    public static CompatSphereClient of(SphereClientConfig clientConfig, ExceptionMode exceptionMode) {
        return CompatSphereClient.of(CompatSphereClient.createDefaultClient(clientConfig), SphereJsonUtils.newObjectMapper(), clientConfig.getProjectKey(), exceptionMode);
    }

    public static CompatSphereClient of(ProjectApiRoot apiRoot, ExceptionMode exceptionMode) {
        return CompatSphereClient.of(apiRoot.getApiHttpClient(), SphereJsonUtils.newObjectMapper(), apiRoot.getProjectKey(), exceptionMode);
    }

    public static CompatSphereClient of(ProjectApiRoot apiRoot, ObjectMapper mapper, ExceptionMode exceptionMode) {
        return CompatSphereClient.of(apiRoot.getApiHttpClient(), mapper, apiRoot.getProjectKey(), exceptionMode);
    }

    public static CompatSphereClient of(ApiHttpClient apiHttpClient, String projectKey, ExceptionMode exceptionMode) {
        return CompatSphereClient.of(apiHttpClient, SphereJsonUtils.newObjectMapper(), projectKey, exceptionMode);
    }

    public static CompatSphereClient of(ApiHttpClient apiHttpClient, ObjectMapper mapper, String projectKey, ExceptionMode exceptionMode) {
        return new CompatSphereClient(apiHttpClient, mapper, projectKey, exceptionMode);
    }

    private static ApiHttpClient createDefaultClient(SphereClientConfig clientConfig) {
        URI resolve = URI.create(clientConfig.getApiUrl()).resolve("/" + clientConfig.getProjectKey() + "/");
        return ApiRootBuilder.of().defaultClient(resolve).addCorrelationIdProvider(() -> clientConfig.getCorrelationIdGenerator().get()).withClientCredentialsFlow((ClientCredentials)ClientCredentials.of().withClientId(clientConfig.getClientId()).withClientSecret(clientConfig.getClientSecret()).build(), URI.create(clientConfig.getAuthUrl()).resolve("/oauth/token")).buildClient();
    }

    public <T> CompletionStage<T> execute(SphereRequest<T> sphereRequest) {
        CompatRequest<JsonNode> compatRequest = CompatRequest.of(this.client, this.projectKey, sphereRequest, JsonNode.class);
        HttpRequest httpRequest = sphereRequest.httpRequestIntent().toHttpRequest(this.client.getBaseUri().toString());
        if (this.exceptionMode == ExceptionMode.SDK_V2) {
            return ((CompletableFuture)compatRequest.send().thenApply(response -> HttpResponse.of((Integer)response.getStatusCode(), (byte[])((byte[])response.getBody()), (HttpRequest)httpRequest, (HttpHeaders)HttpHeaders.ofMapEntryList((List)response.getHeaders().getHeaders())))).thenApplyAsync(arg_0 -> sphereRequest.deserialize(arg_0));
        }
        CompletableFuture result = new CompletableFuture();
        ((CompletableFuture)compatRequest.send().thenApply(response -> HttpResponse.of((Integer)response.getStatusCode(), (byte[])((byte[])response.getBody()), (HttpRequest)httpRequest, (HttpHeaders)HttpHeaders.ofMapEntryList((List)response.getHeaders().getHeaders())))).whenComplete((httpResponse, throwable) -> {
            if (throwable != null) {
                Throwable cause;
                Throwable throwable2 = cause = throwable instanceof CompletionException ? throwable.getCause() : throwable;
                if (cause instanceof ApiHttpException) {
                    ApiHttpResponse errorResponse = ((ApiHttpException)cause).getResponse();
                    if (errorResponse != null) {
                        HttpResponse httpErrorResponse = HttpResponse.of((Integer)errorResponse.getStatusCode(), (byte[])((byte[])errorResponse.getBody()), (HttpRequest)httpRequest, (HttpHeaders)HttpHeaders.ofMapEntryList((List)errorResponse.getHeaders().getHeaders()));
                        SphereException e = CompatSphereClient.createExceptionFor(httpErrorResponse, sphereRequest, this.mapper, this.projectKey, httpRequest);
                        result.completeExceptionally((Throwable)e);
                    } else {
                        result.completeExceptionally(cause);
                    }
                }
            }
            try {
                result.complete(sphereRequest.deserialize(httpResponse));
            }
            catch (JsonException e) {
                byte[] bytes = httpResponse.getResponseBody();
                e.addNote("Cannot parse " + CompatSphereClient.bytesToString(bytes));
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    private static <T> SphereException createExceptionFor(HttpResponse httpResponse, SphereRequest<T> sphereRequest, ObjectMapper objectMapper, String projectKey, HttpRequest httpRequest) {
        SphereException sphereException = CompatExceptionFactory.of().createException(httpResponse, sphereRequest, objectMapper);
        CompatSphereClient.fillExceptionWithData(sphereRequest, httpResponse, sphereException, projectKey, httpRequest);
        return sphereException;
    }

    private static <T> void fillExceptionWithData(SphereRequest<T> sphereRequest, HttpResponse httpResponse, SphereException exception, String projectKey, HttpRequest httpRequest) {
        exception.setSphereRequest(sphereRequest);
        exception.setUnderlyingHttpResponse(httpResponse);
        exception.setProjectKey(projectKey);
        exception.setHttpRequest(httpRequest);
    }

    private static String bytesToString(byte[] b) {
        return new String(b, StandardCharsets.UTF_8);
    }

    protected void internalClose() {
        CompatSphereClient.closeQuietly((AutoCloseable)this.client);
    }

    public SphereApiConfig getConfig() {
        return new SphereApiConfig(){

            public String getApiUrl() {
                return CompatSphereClient.this.client.getBaseUri().toString();
            }

            public String getProjectKey() {
                return CompatSphereClient.this.projectKey;
            }

            public CorrelationIdGenerator getCorrelationIdGenerator() {
                return null;
            }
        };
    }

    public static class CompatApiHttpClient
    extends AutoCloseableService
    implements ApiHttpClient {
        private final ApiHttpClient apiHttpClient;
        private final ResponseSerializer serializer;

        public CompatApiHttpClient(ApiHttpClient apiHttpClient, ObjectMapper mapper) {
            this.apiHttpClient = apiHttpClient;
            this.serializer = ResponseSerializer.of((ObjectMapper)mapper);
        }

        public URI getBaseUri() {
            return this.apiHttpClient.getBaseUri();
        }

        public ResponseSerializer getSerializerService() {
            return this.serializer;
        }

        public CompletableFuture<ApiHttpResponse<byte[]>> execute(ApiHttpRequest request) {
            return this.apiHttpClient.execute(request);
        }

        protected void internalClose() {
            CompatApiHttpClient.closeQuietly((AutoCloseable)this.apiHttpClient);
        }
    }

    public static enum ExceptionMode {
        SDK_V1,
        SDK_V2;

    }
}

