/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.change_history;

import com.commercetools.history.models.change.Change;
import com.commercetools.history.models.change_history.ModifiedBy;
import com.commercetools.history.models.change_history.RecordBuilder;
import com.commercetools.history.models.change_history.RecordImpl;
import com.commercetools.history.models.common.KeyReference;
import com.commercetools.history.models.common.ResourceIdentifier;
import com.commercetools.history.models.label.Label;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as=RecordImpl.class)
public interface Record {
    @NotNull
    @JsonProperty(value="version")
    public Integer getVersion();

    @NotNull
    @JsonProperty(value="previousVersion")
    public Integer getPreviousVersion();

    @NotNull
    @JsonProperty(value="type")
    public String getType();

    @NotNull
    @Valid
    @JsonProperty(value="modifiedBy")
    public ModifiedBy getModifiedBy();

    @NotNull
    @JsonProperty(value="modifiedAt")
    public String getModifiedAt();

    @NotNull
    @Valid
    @JsonProperty(value="label")
    public Label getLabel();

    @NotNull
    @Valid
    @JsonProperty(value="previousLabel")
    public Label getPreviousLabel();

    @NotNull
    @Valid
    @JsonProperty(value="changes")
    public List<Change> getChanges();

    @NotNull
    @Valid
    @JsonProperty(value="resource")
    public ResourceIdentifier getResource();

    @NotNull
    @Valid
    @JsonProperty(value="stores")
    public List<KeyReference> getStores();

    @NotNull
    @JsonProperty(value="withoutChanges")
    public Boolean getWithoutChanges();

    public void setVersion(Integer var1);

    public void setPreviousVersion(Integer var1);

    public void setType(String var1);

    public void setModifiedBy(ModifiedBy var1);

    public void setModifiedAt(String var1);

    public void setLabel(Label var1);

    public void setPreviousLabel(Label var1);

    @JsonIgnore
    public void setChanges(Change ... var1);

    public void setChanges(List<Change> var1);

    public void setResource(ResourceIdentifier var1);

    @JsonIgnore
    public void setStores(KeyReference ... var1);

    public void setStores(List<KeyReference> var1);

    public void setWithoutChanges(Boolean var1);

    public static Record of() {
        return new RecordImpl();
    }

    public static Record of(Record template) {
        RecordImpl instance = new RecordImpl();
        instance.setVersion(template.getVersion());
        instance.setPreviousVersion(template.getPreviousVersion());
        instance.setType(template.getType());
        instance.setModifiedBy(template.getModifiedBy());
        instance.setModifiedAt(template.getModifiedAt());
        instance.setLabel(template.getLabel());
        instance.setPreviousLabel(template.getPreviousLabel());
        instance.setChanges(template.getChanges());
        instance.setResource(template.getResource());
        instance.setStores(template.getStores());
        instance.setWithoutChanges(template.getWithoutChanges());
        return instance;
    }

    @Nullable
    public static Record deepCopy(@Nullable Record template) {
        if (template == null) {
            return null;
        }
        RecordImpl instance = new RecordImpl();
        instance.setVersion(template.getVersion());
        instance.setPreviousVersion(template.getPreviousVersion());
        instance.setType(template.getType());
        instance.setModifiedBy(ModifiedBy.deepCopy(template.getModifiedBy()));
        instance.setModifiedAt(template.getModifiedAt());
        instance.setLabel(Label.deepCopy(template.getLabel()));
        instance.setPreviousLabel(Label.deepCopy(template.getPreviousLabel()));
        instance.setChanges((List<Change>)Optional.ofNullable(template.getChanges()).map(t -> t.stream().map(Change::deepCopy).collect(Collectors.toList())).orElse(null));
        instance.setResource(ResourceIdentifier.deepCopy(template.getResource()));
        instance.setStores((List<KeyReference>)Optional.ofNullable(template.getStores()).map(t -> t.stream().map(KeyReference::deepCopy).collect(Collectors.toList())).orElse(null));
        instance.setWithoutChanges(template.getWithoutChanges());
        return instance;
    }

    public static RecordBuilder builder() {
        return RecordBuilder.of();
    }

    public static RecordBuilder builder(Record template) {
        return RecordBuilder.of(template);
    }

    default public <T> T withRecord(Function<Record, T> helper) {
        return helper.apply(this);
    }

    public static TypeReference<Record> typeReference() {
        return new TypeReference<Record>(){

            public String toString() {
                return "TypeReference<Record>";
            }
        };
    }
}

