/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.change_history;

import com.commercetools.history.models.change.Change;
import com.commercetools.history.models.change.ChangeBuilder;
import com.commercetools.history.models.change_history.ModifiedBy;
import com.commercetools.history.models.change_history.ModifiedByBuilder;
import com.commercetools.history.models.change_history.Record;
import com.commercetools.history.models.change_history.RecordImpl;
import com.commercetools.history.models.common.KeyReference;
import com.commercetools.history.models.common.KeyReferenceBuilder;
import com.commercetools.history.models.common.ResourceIdentifier;
import com.commercetools.history.models.common.ResourceIdentifierBuilder;
import com.commercetools.history.models.label.Label;
import com.commercetools.history.models.label.LabelBuilder;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class RecordBuilder
implements Builder<Record> {
    private Integer version;
    private Integer previousVersion;
    private String type;
    private ModifiedBy modifiedBy;
    private String modifiedAt;
    private Label label;
    private Label previousLabel;
    private List<Change> changes;
    private ResourceIdentifier resource;
    private List<KeyReference> stores;
    private Boolean withoutChanges;

    public RecordBuilder version(Integer version) {
        this.version = version;
        return this;
    }

    public RecordBuilder previousVersion(Integer previousVersion) {
        this.previousVersion = previousVersion;
        return this;
    }

    public RecordBuilder type(String type) {
        this.type = type;
        return this;
    }

    public RecordBuilder modifiedBy(Function<ModifiedByBuilder, ModifiedByBuilder> builder) {
        this.modifiedBy = builder.apply(ModifiedByBuilder.of()).build();
        return this;
    }

    public RecordBuilder withModifiedBy(Function<ModifiedByBuilder, ModifiedBy> builder) {
        this.modifiedBy = builder.apply(ModifiedByBuilder.of());
        return this;
    }

    public RecordBuilder modifiedBy(ModifiedBy modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    public RecordBuilder modifiedAt(String modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    public RecordBuilder label(Label label) {
        this.label = label;
        return this;
    }

    public RecordBuilder label(Function<LabelBuilder, Builder<? extends Label>> builder) {
        this.label = (Label)builder.apply(LabelBuilder.of()).build();
        return this;
    }

    public RecordBuilder previousLabel(Label previousLabel) {
        this.previousLabel = previousLabel;
        return this;
    }

    public RecordBuilder previousLabel(Function<LabelBuilder, Builder<? extends Label>> builder) {
        this.previousLabel = (Label)builder.apply(LabelBuilder.of()).build();
        return this;
    }

    public RecordBuilder changes(Change ... changes) {
        this.changes = new ArrayList<Change>(Arrays.asList(changes));
        return this;
    }

    public RecordBuilder changes(List<Change> changes) {
        this.changes = changes;
        return this;
    }

    public RecordBuilder plusChanges(Change ... changes) {
        if (this.changes == null) {
            this.changes = new ArrayList<Change>();
        }
        this.changes.addAll(Arrays.asList(changes));
        return this;
    }

    public RecordBuilder plusChanges(Function<ChangeBuilder, Builder<? extends Change>> builder) {
        if (this.changes == null) {
            this.changes = new ArrayList<Change>();
        }
        this.changes.add((Change)builder.apply(ChangeBuilder.of()).build());
        return this;
    }

    public RecordBuilder withChanges(Function<ChangeBuilder, Builder<? extends Change>> builder) {
        this.changes = new ArrayList<Change>();
        this.changes.add((Change)builder.apply(ChangeBuilder.of()).build());
        return this;
    }

    public RecordBuilder resource(Function<ResourceIdentifierBuilder, ResourceIdentifierBuilder> builder) {
        this.resource = builder.apply(ResourceIdentifierBuilder.of()).build();
        return this;
    }

    public RecordBuilder withResource(Function<ResourceIdentifierBuilder, ResourceIdentifier> builder) {
        this.resource = builder.apply(ResourceIdentifierBuilder.of());
        return this;
    }

    public RecordBuilder resource(ResourceIdentifier resource) {
        this.resource = resource;
        return this;
    }

    public RecordBuilder stores(KeyReference ... stores) {
        this.stores = new ArrayList<KeyReference>(Arrays.asList(stores));
        return this;
    }

    public RecordBuilder stores(List<KeyReference> stores) {
        this.stores = stores;
        return this;
    }

    public RecordBuilder plusStores(KeyReference ... stores) {
        if (this.stores == null) {
            this.stores = new ArrayList<KeyReference>();
        }
        this.stores.addAll(Arrays.asList(stores));
        return this;
    }

    public RecordBuilder plusStores(Function<KeyReferenceBuilder, KeyReferenceBuilder> builder) {
        if (this.stores == null) {
            this.stores = new ArrayList<KeyReference>();
        }
        this.stores.add(builder.apply(KeyReferenceBuilder.of()).build());
        return this;
    }

    public RecordBuilder withStores(Function<KeyReferenceBuilder, KeyReferenceBuilder> builder) {
        this.stores = new ArrayList<KeyReference>();
        this.stores.add(builder.apply(KeyReferenceBuilder.of()).build());
        return this;
    }

    public RecordBuilder addStores(Function<KeyReferenceBuilder, KeyReference> builder) {
        return this.plusStores(builder.apply(KeyReferenceBuilder.of()));
    }

    public RecordBuilder setStores(Function<KeyReferenceBuilder, KeyReference> builder) {
        return this.stores(builder.apply(KeyReferenceBuilder.of()));
    }

    public RecordBuilder withoutChanges(Boolean withoutChanges) {
        this.withoutChanges = withoutChanges;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Integer getPreviousVersion() {
        return this.previousVersion;
    }

    public String getType() {
        return this.type;
    }

    public ModifiedBy getModifiedBy() {
        return this.modifiedBy;
    }

    public String getModifiedAt() {
        return this.modifiedAt;
    }

    public Label getLabel() {
        return this.label;
    }

    public Label getPreviousLabel() {
        return this.previousLabel;
    }

    public List<Change> getChanges() {
        return this.changes;
    }

    public ResourceIdentifier getResource() {
        return this.resource;
    }

    public List<KeyReference> getStores() {
        return this.stores;
    }

    public Boolean getWithoutChanges() {
        return this.withoutChanges;
    }

    public Record build() {
        Objects.requireNonNull(this.version, Record.class + ": version is missing");
        Objects.requireNonNull(this.previousVersion, Record.class + ": previousVersion is missing");
        Objects.requireNonNull(this.type, Record.class + ": type is missing");
        Objects.requireNonNull(this.modifiedBy, Record.class + ": modifiedBy is missing");
        Objects.requireNonNull(this.modifiedAt, Record.class + ": modifiedAt is missing");
        Objects.requireNonNull(this.label, Record.class + ": label is missing");
        Objects.requireNonNull(this.previousLabel, Record.class + ": previousLabel is missing");
        Objects.requireNonNull(this.changes, Record.class + ": changes is missing");
        Objects.requireNonNull(this.resource, Record.class + ": resource is missing");
        Objects.requireNonNull(this.stores, Record.class + ": stores is missing");
        Objects.requireNonNull(this.withoutChanges, Record.class + ": withoutChanges is missing");
        return new RecordImpl(this.version, this.previousVersion, this.type, this.modifiedBy, this.modifiedAt, this.label, this.previousLabel, this.changes, this.resource, this.stores, this.withoutChanges);
    }

    public Record buildUnchecked() {
        return new RecordImpl(this.version, this.previousVersion, this.type, this.modifiedBy, this.modifiedAt, this.label, this.previousLabel, this.changes, this.resource, this.stores, this.withoutChanges);
    }

    public static RecordBuilder of() {
        return new RecordBuilder();
    }

    public static RecordBuilder of(Record template) {
        RecordBuilder builder = new RecordBuilder();
        builder.version = template.getVersion();
        builder.previousVersion = template.getPreviousVersion();
        builder.type = template.getType();
        builder.modifiedBy = template.getModifiedBy();
        builder.modifiedAt = template.getModifiedAt();
        builder.label = template.getLabel();
        builder.previousLabel = template.getPreviousLabel();
        builder.changes = template.getChanges();
        builder.resource = template.getResource();
        builder.stores = template.getStores();
        builder.withoutChanges = template.getWithoutChanges();
        return builder;
    }
}

