
package com.commercetools.history.models.change;

import java.util.*;

import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;

/**
 * ChangeAttributeOrderByNameChangeBuilder
 * <hr>
 * Example to create an instance using the builder pattern
 * <div class=code-example>
 * <pre><code class='java'>
 *     ChangeAttributeOrderByNameChange changeAttributeOrderByNameChange = ChangeAttributeOrderByNameChange.builder()
 *             .change("{change}")
 *             .plusPreviousValue(previousValueBuilder -> previousValueBuilder)
 *             .plusNextValue(nextValueBuilder -> nextValueBuilder)
 *             .build()
 * </code></pre>
 * </div>
 */
@Generated(value = "io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments = "https://github.com/commercetools/rmf-codegen")
public class ChangeAttributeOrderByNameChangeBuilder implements Builder<ChangeAttributeOrderByNameChange> {

    private String change;

    private java.util.List<String> previousValue;

    private java.util.List<String> nextValue;

    /**
     * set the value to the change
     * @param change value to be set
     * @return Builder
     */

    public ChangeAttributeOrderByNameChangeBuilder change(final String change) {
        this.change = change;
        return this;
    }

    /**
     *  <p>Value before the change.</p>
     * @param previousValue value to be set
     * @return Builder
     */

    public ChangeAttributeOrderByNameChangeBuilder previousValue(final String... previousValue) {
        this.previousValue = new ArrayList<>(Arrays.asList(previousValue));
        return this;
    }

    /**
     *  <p>Value before the change.</p>
     * @param previousValue value to be set
     * @return Builder
     */

    public ChangeAttributeOrderByNameChangeBuilder previousValue(final java.util.List<String> previousValue) {
        this.previousValue = previousValue;
        return this;
    }

    /**
     *  <p>Value before the change.</p>
     * @param previousValue value to be set
     * @return Builder
     */

    public ChangeAttributeOrderByNameChangeBuilder plusPreviousValue(final String... previousValue) {
        if (this.previousValue == null) {
            this.previousValue = new ArrayList<>();
        }
        this.previousValue.addAll(Arrays.asList(previousValue));
        return this;
    }

    /**
     *  <p>Value after the change.</p>
     * @param nextValue value to be set
     * @return Builder
     */

    public ChangeAttributeOrderByNameChangeBuilder nextValue(final String... nextValue) {
        this.nextValue = new ArrayList<>(Arrays.asList(nextValue));
        return this;
    }

    /**
     *  <p>Value after the change.</p>
     * @param nextValue value to be set
     * @return Builder
     */

    public ChangeAttributeOrderByNameChangeBuilder nextValue(final java.util.List<String> nextValue) {
        this.nextValue = nextValue;
        return this;
    }

    /**
     *  <p>Value after the change.</p>
     * @param nextValue value to be set
     * @return Builder
     */

    public ChangeAttributeOrderByNameChangeBuilder plusNextValue(final String... nextValue) {
        if (this.nextValue == null) {
            this.nextValue = new ArrayList<>();
        }
        this.nextValue.addAll(Arrays.asList(nextValue));
        return this;
    }

    /**
     * value of change}
     * @return change
     */

    public String getChange() {
        return this.change;
    }

    /**
     *  <p>Value before the change.</p>
     * @return previousValue
     */

    public java.util.List<String> getPreviousValue() {
        return this.previousValue;
    }

    /**
     *  <p>Value after the change.</p>
     * @return nextValue
     */

    public java.util.List<String> getNextValue() {
        return this.nextValue;
    }

    /**
     * builds ChangeAttributeOrderByNameChange with checking for non-null required values
     * @return ChangeAttributeOrderByNameChange
     */
    public ChangeAttributeOrderByNameChange build() {
        Objects.requireNonNull(change, ChangeAttributeOrderByNameChange.class + ": change is missing");
        Objects.requireNonNull(previousValue, ChangeAttributeOrderByNameChange.class + ": previousValue is missing");
        Objects.requireNonNull(nextValue, ChangeAttributeOrderByNameChange.class + ": nextValue is missing");
        return new ChangeAttributeOrderByNameChangeImpl(change, previousValue, nextValue);
    }

    /**
     * builds ChangeAttributeOrderByNameChange without checking for non-null required values
     * @return ChangeAttributeOrderByNameChange
     */
    public ChangeAttributeOrderByNameChange buildUnchecked() {
        return new ChangeAttributeOrderByNameChangeImpl(change, previousValue, nextValue);
    }

    /**
     * factory method for an instance of ChangeAttributeOrderByNameChangeBuilder
     * @return builder
     */
    public static ChangeAttributeOrderByNameChangeBuilder of() {
        return new ChangeAttributeOrderByNameChangeBuilder();
    }

    /**
     * create builder for ChangeAttributeOrderByNameChange instance
     * @param template instance with prefilled values for the builder
     * @return builder
     */
    public static ChangeAttributeOrderByNameChangeBuilder of(final ChangeAttributeOrderByNameChange template) {
        ChangeAttributeOrderByNameChangeBuilder builder = new ChangeAttributeOrderByNameChangeBuilder();
        builder.change = template.getChange();
        builder.previousValue = template.getPreviousValue();
        builder.nextValue = template.getNextValue();
        return builder;
    }

}
