
package com.commercetools.history.models.change;

import java.util.*;

import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;

/**
 * ChangeSortOrderChangeBuilder
 * <hr>
 * Example to create an instance using the builder pattern
 * <div class=code-example>
 * <pre><code class='java'>
 *     ChangeSortOrderChange changeSortOrderChange = ChangeSortOrderChange.builder()
 *             .change("{change}")
 *             .previousValue("{previousValue}")
 *             .nextValue("{nextValue}")
 *             .build()
 * </code></pre>
 * </div>
 */
@Generated(value = "io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments = "https://github.com/commercetools/rmf-codegen")
public class ChangeSortOrderChangeBuilder implements Builder<ChangeSortOrderChange> {

    private String change;

    private String previousValue;

    private String nextValue;

    /**
     * set the value to the change
     * @param change value to be set
     * @return Builder
     */

    public ChangeSortOrderChangeBuilder change(final String change) {
        this.change = change;
        return this;
    }

    /**
     *  <p>Value before the change.</p>
     * @param previousValue value to be set
     * @return Builder
     */

    public ChangeSortOrderChangeBuilder previousValue(final String previousValue) {
        this.previousValue = previousValue;
        return this;
    }

    /**
     *  <p>Value after the change.</p>
     * @param nextValue value to be set
     * @return Builder
     */

    public ChangeSortOrderChangeBuilder nextValue(final String nextValue) {
        this.nextValue = nextValue;
        return this;
    }

    /**
     * value of change}
     * @return change
     */

    public String getChange() {
        return this.change;
    }

    /**
     *  <p>Value before the change.</p>
     * @return previousValue
     */

    public String getPreviousValue() {
        return this.previousValue;
    }

    /**
     *  <p>Value after the change.</p>
     * @return nextValue
     */

    public String getNextValue() {
        return this.nextValue;
    }

    /**
     * builds ChangeSortOrderChange with checking for non-null required values
     * @return ChangeSortOrderChange
     */
    public ChangeSortOrderChange build() {
        Objects.requireNonNull(change, ChangeSortOrderChange.class + ": change is missing");
        Objects.requireNonNull(previousValue, ChangeSortOrderChange.class + ": previousValue is missing");
        Objects.requireNonNull(nextValue, ChangeSortOrderChange.class + ": nextValue is missing");
        return new ChangeSortOrderChangeImpl(change, previousValue, nextValue);
    }

    /**
     * builds ChangeSortOrderChange without checking for non-null required values
     * @return ChangeSortOrderChange
     */
    public ChangeSortOrderChange buildUnchecked() {
        return new ChangeSortOrderChangeImpl(change, previousValue, nextValue);
    }

    /**
     * factory method for an instance of ChangeSortOrderChangeBuilder
     * @return builder
     */
    public static ChangeSortOrderChangeBuilder of() {
        return new ChangeSortOrderChangeBuilder();
    }

    /**
     * create builder for ChangeSortOrderChange instance
     * @param template instance with prefilled values for the builder
     * @return builder
     */
    public static ChangeSortOrderChangeBuilder of(final ChangeSortOrderChange template) {
        ChangeSortOrderChangeBuilder builder = new ChangeSortOrderChangeBuilder();
        builder.change = template.getChange();
        builder.previousValue = template.getPreviousValue();
        builder.nextValue = template.getNextValue();
        return builder;
    }

}
