/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.defaultconfig;

import com.commercetools.history.client.ApiRoot;
import com.commercetools.history.client.ByProjectKeyRequestBuilder;
import com.commercetools.history.client.HistoryCorrelationIdProvider;
import com.commercetools.history.client.ProjectApiRoot;
import com.commercetools.history.defaultconfig.ServiceRegion;
import dev.failsafe.spi.Scheduler;
import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.ClientBuilder;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.ServiceRegionConfig;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.error.HttpExceptionFactory;
import io.vrap.rmf.base.client.http.CorrelationIdProvider;
import io.vrap.rmf.base.client.http.ErrorLogFormatter;
import io.vrap.rmf.base.client.http.ErrorMiddleware;
import io.vrap.rmf.base.client.http.FailsafeRetryPolicyBuilderOptions;
import io.vrap.rmf.base.client.http.HandlerStack;
import io.vrap.rmf.base.client.http.InternalLoggerFactory;
import io.vrap.rmf.base.client.http.InternalLoggerMiddleware;
import io.vrap.rmf.base.client.http.Middleware;
import io.vrap.rmf.base.client.http.OAuthMiddleware;
import io.vrap.rmf.base.client.http.PolicyBuilder;
import io.vrap.rmf.base.client.http.QueueRequestMiddleware;
import io.vrap.rmf.base.client.http.ResponseLogFormatter;
import io.vrap.rmf.base.client.http.RetryRequestMiddleware;
import io.vrap.rmf.base.client.oauth2.ClientCredentials;
import io.vrap.rmf.base.client.oauth2.TokenSupplier;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.slf4j.event.Level;

public class HistoryApiRootBuilder {
    private final ClientBuilder builder;

    private HistoryApiRootBuilder(ClientBuilder builder) {
        this.builder = builder;
    }

    public static HistoryApiRootBuilder of() {
        return new HistoryApiRootBuilder(ClientBuilder.of());
    }

    public static HistoryApiRootBuilder of(VrapHttpClient httpClient) {
        return new HistoryApiRootBuilder(ClientBuilder.of((VrapHttpClient)httpClient));
    }

    public static HistoryApiRootBuilder of(HandlerStack stack) {
        return new HistoryApiRootBuilder(ClientBuilder.of((HandlerStack)stack));
    }

    public HistoryApiRootBuilder withAuthCircuitBreaker() {
        this.builder.withAuthCircuitBreaker();
        return this;
    }

    public HistoryApiRootBuilder withoutAuthCircuitBreaker() {
        this.builder.withoutAuthCircuitBreaker();
        return this;
    }

    public HistoryApiRootBuilder withAuthRetries(int authRetries) {
        this.builder.withAuthRetries(authRetries);
        return this;
    }

    public HistoryApiRootBuilder withHandlerStack(HandlerStack stack) {
        this.builder.withHandlerStack(stack);
        return this;
    }

    public HistoryApiRootBuilder withHttpClient(VrapHttpClient httpClient) {
        this.builder.withHttpClient(httpClient);
        return this;
    }

    public HistoryApiRootBuilder withSerializer(ResponseSerializer serializer) {
        this.builder.withSerializer(serializer);
        return this;
    }

    public HistoryApiRootBuilder withSerializer(Supplier<ResponseSerializer> serializer) {
        this.builder.withSerializer(serializer);
        return this;
    }

    public HistoryApiRootBuilder withHttpExceptionFactory(HttpExceptionFactory factory) {
        this.builder.withHttpExceptionFactory(factory);
        return this;
    }

    public HistoryApiRootBuilder withHttpExceptionFactory(Function<ResponseSerializer, HttpExceptionFactory> factory) {
        this.builder.withHttpExceptionFactory(factory);
        return this;
    }

    public HistoryApiRootBuilder withHttpExceptionFactory(Supplier<HttpExceptionFactory> factory) {
        this.builder.withHttpExceptionFactory(factory);
        return this;
    }

    public HistoryApiRootBuilder defaultClient(ClientCredentials credentials) {
        return this.defaultClient(credentials, ServiceRegion.GCP_EUROPE_WEST1);
    }

    public HistoryApiRootBuilder defaultClient(ClientCredentials credentials, ServiceRegionConfig serviceRegion) {
        this.builder.defaultClient(credentials, serviceRegion);
        return this;
    }

    public HistoryApiRootBuilder defaultClient(ClientCredentials credentials, String tokenEndpoint, String apiEndpoint) {
        return this.defaultClient(URI.create(apiEndpoint)).withClientCredentialsFlow(credentials, tokenEndpoint);
    }

    public HistoryApiRootBuilder defaultClient(String apiEndpoint, ClientCredentials credentials, String tokenEndpoint) {
        return this.defaultClient(URI.create(apiEndpoint)).withClientCredentialsFlow(credentials, tokenEndpoint);
    }

    public HistoryApiRootBuilder defaultClient(String apiEndpoint) {
        return this.defaultClient(URI.create(apiEndpoint));
    }

    public HistoryApiRootBuilder defaultClient(URI apiEndpoint) {
        this.builder.defaultClient(apiEndpoint);
        return this;
    }

    public HistoryApiRootBuilder withClientCredentialsFlow(ClientCredentials credentials, String tokenEndpoint) {
        this.builder.withClientCredentialsFlow(credentials, tokenEndpoint);
        return this;
    }

    public HistoryApiRootBuilder withClientCredentialsFlow(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient) {
        this.builder.withClientCredentialsFlow(credentials, tokenEndpoint, httpClient);
        return this;
    }

    public HistoryApiRootBuilder withClientCredentialsFlow(ClientCredentials credentials, URI tokenEndpoint) {
        this.builder.withClientCredentialsFlow(credentials, tokenEndpoint);
        return this;
    }

    public HistoryApiRootBuilder withClientCredentialsFlow(ClientCredentials credentials, URI tokenEndpoint, VrapHttpClient httpClient) {
        this.builder.withClientCredentialsFlow(credentials, tokenEndpoint, httpClient);
        return this;
    }

    public HistoryApiRootBuilder withStaticTokenFlow(AuthenticationToken token) {
        this.builder.withStaticTokenFlow(token);
        return this;
    }

    public HistoryApiRootBuilder withAnonymousSessionFlow(ClientCredentials credentials, String tokenEndpoint) {
        this.builder.withAnonymousSessionFlow(credentials, tokenEndpoint);
        return this;
    }

    public HistoryApiRootBuilder withAnonymousSessionFlow(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient) {
        this.builder.withAnonymousSessionFlow(credentials, tokenEndpoint, httpClient);
        return this;
    }

    public HistoryApiRootBuilder withGlobalCustomerPasswordFlow(ClientCredentials credentials, String email, String password, String tokenEndpoint) {
        this.builder.withGlobalCustomerPasswordFlow(credentials, email, password, tokenEndpoint);
        return this;
    }

    public HistoryApiRootBuilder withGlobalCustomerPasswordFlow(ClientCredentials credentials, String email, String password, String tokenEndpoint, VrapHttpClient httpClient) {
        this.builder.withGlobalCustomerPasswordFlow(credentials, email, password, tokenEndpoint, httpClient);
        return this;
    }

    public HistoryApiRootBuilder addAcceptGZipMiddleware() {
        this.builder.addAcceptGZipMiddleware();
        return this;
    }

    public HistoryApiRootBuilder withErrorMiddleware() {
        this.builder.withErrorMiddleware();
        return this;
    }

    public HistoryApiRootBuilder withErrorMiddleware(ErrorMiddleware errorMiddleware) {
        this.builder.withErrorMiddleware(errorMiddleware);
        return this;
    }

    public HistoryApiRootBuilder withPolicies(Function<PolicyBuilder, PolicyBuilder> fn) {
        return this.with(clientBuilder -> clientBuilder.withPolicies(fn));
    }

    @Deprecated
    public HistoryApiRootBuilder withRetryMiddleware(Supplier<RetryRequestMiddleware> retryMiddleware) {
        this.builder.withRetryMiddleware(retryMiddleware);
        return this;
    }

    @Deprecated
    public HistoryApiRootBuilder withRetryMiddleware(RetryRequestMiddleware retryMiddleware) {
        this.builder.withRetryMiddleware(retryMiddleware);
        return this;
    }

    @Deprecated
    public HistoryApiRootBuilder withRetryMiddleware(int maxRetries) {
        this.builder.withRetryMiddleware(maxRetries);
        return this;
    }

    @Deprecated
    public HistoryApiRootBuilder withRetryMiddleware(int maxRetries, List<Integer> statusCodes) {
        this.builder.withRetryMiddleware(maxRetries, statusCodes);
        return this;
    }

    @Deprecated
    public HistoryApiRootBuilder withRetryMiddleware(int maxRetries, List<Integer> statusCodes, List<Class<? extends Throwable>> failures) {
        this.builder.withRetryMiddleware(maxRetries, statusCodes, failures);
        return this;
    }

    @Deprecated
    public HistoryApiRootBuilder withRetryMiddleware(int maxRetries, long delay, long maxDelay, List<Integer> statusCodes, List<Class<? extends Throwable>> failures, FailsafeRetryPolicyBuilderOptions fn) {
        this.builder.withRetryMiddleware(maxRetries, delay, maxDelay, statusCodes, failures, fn);
        return this;
    }

    @Deprecated
    public HistoryApiRootBuilder withRetryMiddleware(int maxRetries, long delay, long maxDelay, FailsafeRetryPolicyBuilderOptions fn) {
        this.builder.withRetryMiddleware(maxRetries, delay, maxDelay, fn);
        return this;
    }

    public HistoryApiRootBuilder withOAuthMiddleware(Supplier<OAuthMiddleware> oAuthMiddleware) {
        this.builder.withOAuthMiddleware(oAuthMiddleware);
        return this;
    }

    @Deprecated
    public HistoryApiRootBuilder withQueueMiddleware(Supplier<QueueRequestMiddleware> queueMiddleware) {
        return this.with(clientBuilder -> clientBuilder.withQueueMiddleware(queueMiddleware));
    }

    @Deprecated
    public HistoryApiRootBuilder withQueueMiddleware(QueueRequestMiddleware queueMiddleware) {
        return this.with(clientBuilder -> clientBuilder.withQueueMiddleware(queueMiddleware));
    }

    @Deprecated
    public HistoryApiRootBuilder withQueueMiddleware(int maxRequests, Duration maxWaitTime) {
        return this.with(clientBuilder -> clientBuilder.withQueueMiddleware(maxRequests, maxWaitTime));
    }

    @Deprecated
    public HistoryApiRootBuilder withQueueMiddleware(Scheduler scheduler, int maxRequests, Duration maxWaitTime) {
        return this.with(clientBuilder -> clientBuilder.withQueueMiddleware(scheduler, maxRequests, maxWaitTime));
    }

    @Deprecated
    public HistoryApiRootBuilder withQueueMiddleware(ScheduledExecutorService executorService, int maxRequests, Duration maxWaitTime) {
        return this.with(clientBuilder -> clientBuilder.withQueueMiddleware(executorService, maxRequests, maxWaitTime));
    }

    @Deprecated
    public HistoryApiRootBuilder withQueueMiddleware(ExecutorService executorService, int maxRequests, Duration maxWaitTime) {
        return this.with(clientBuilder -> clientBuilder.withQueueMiddleware(executorService, maxRequests, maxWaitTime));
    }

    public HistoryApiRootBuilder withOAuthMiddleware(OAuthMiddleware oAuthMiddleware) {
        this.builder.withOAuthMiddleware(oAuthMiddleware);
        return this;
    }

    public HistoryApiRootBuilder withTokenSupplier(TokenSupplier tokenSupplier) {
        this.builder.withTokenSupplier(tokenSupplier);
        return this;
    }

    public HistoryApiRootBuilder withTokenSupplier(Supplier<TokenSupplier> tokenSupplier) {
        this.builder.withTokenSupplier(tokenSupplier);
        return this;
    }

    public HistoryApiRootBuilder withInternalLoggerMiddleware(InternalLoggerMiddleware internalLoggerMiddleware) {
        this.builder.withInternalLoggerMiddleware(internalLoggerMiddleware);
        return this;
    }

    public HistoryApiRootBuilder withInternalLoggerFactory(InternalLoggerFactory internalLoggerFactory) {
        this.builder.withInternalLoggerFactory(internalLoggerFactory);
        return this;
    }

    public HistoryApiRootBuilder withInternalLoggerFactory(InternalLoggerFactory internalLoggerFactory, Level responseLogEvent, Level deprecationLogEvent) {
        this.builder.withInternalLoggerFactory(internalLoggerFactory, responseLogEvent, deprecationLogEvent);
        return this;
    }

    public HistoryApiRootBuilder withInternalLoggerFactory(InternalLoggerFactory internalLoggerFactory, Level responseLogEvent, Level deprecationLogEvent, Level defaultExceptionLogEvent, Map<Class<? extends Throwable>, Level> exceptionLogEvents) {
        this.builder.withInternalLoggerFactory(internalLoggerFactory, responseLogEvent, deprecationLogEvent, defaultExceptionLogEvent, exceptionLogEvents);
        return this;
    }

    public HistoryApiRootBuilder withInternalLoggerFactory(InternalLoggerFactory internalLoggerFactory, Level responseLogEvent, Level deprecationLogEvent, Level defaultExceptionLogEvent, Map<Class<? extends Throwable>, Level> exceptionLogEvents, ResponseLogFormatter responseLogFormatter, ErrorLogFormatter errorLogFormatter) {
        return this.with(clientBuilder -> clientBuilder.withInternalLoggerFactory(internalLoggerFactory, responseLogEvent, deprecationLogEvent, defaultExceptionLogEvent, exceptionLogEvents, responseLogFormatter, errorLogFormatter));
    }

    public HistoryApiRootBuilder withApiBaseUrl(String apiBaseUrl) {
        this.builder.withApiBaseUrl(apiBaseUrl);
        return this;
    }

    public HistoryApiRootBuilder withApiBaseUrl(URI apiBaseUrl) {
        this.builder.withApiBaseUrl(apiBaseUrl);
        return this;
    }

    public HistoryApiRootBuilder withUserAgentSupplier(Supplier<String> userAgentSupplier) {
        this.builder.withUserAgentSupplier(userAgentSupplier);
        return this;
    }

    public HistoryApiRootBuilder addCorrelationIdProvider(@Nullable CorrelationIdProvider correlationIdProvider) {
        return this.addCorrelationIdProvider(correlationIdProvider, true);
    }

    private HistoryApiRootBuilder addCorrelationIdProvider(@Nullable CorrelationIdProvider correlationIdProvider, boolean replace) {
        this.builder.addCorrelationIdProvider(correlationIdProvider, replace);
        return this;
    }

    public HistoryApiRootBuilder withMiddleware(Middleware middleware, Middleware ... middlewares) {
        this.builder.withMiddleware(middleware, middlewares);
        return this;
    }

    public HistoryApiRootBuilder addMiddleware(Middleware middleware, Middleware ... middlewares) {
        this.builder.addMiddleware(middleware, middlewares);
        return this;
    }

    public HistoryApiRootBuilder withMiddlewares(List<Middleware> middlewares) {
        this.builder.withMiddlewares(middlewares);
        return this;
    }

    public HistoryApiRootBuilder addMiddlewares(List<Middleware> middlewares) {
        this.builder.addMiddlewares(middlewares);
        return this;
    }

    public HistoryApiRootBuilder with(UnaryOperator<ClientBuilder> builderUnaryOperator) {
        builderUnaryOperator.apply(this.builder);
        return this;
    }

    public ApiRoot build() {
        return ApiRoot.fromClient(this.clientSupplier().get());
    }

    public ApiHttpClient buildClient() {
        return this.clientSupplier().get();
    }

    public Supplier<ApiHttpClient> clientSupplier() {
        return () -> ((ClientBuilder)this.builder).build();
    }

    @Deprecated
    public ByProjectKeyRequestBuilder buildForProject(String projectKey) {
        this.addCorrelationIdProvider(new HistoryCorrelationIdProvider(projectKey), false);
        return ApiRoot.fromClient(this.builder.build()).withProjectKeyValue(projectKey);
    }

    @Deprecated
    public ProjectApiRoot buildProjectRoot(String projectKey) {
        this.addCorrelationIdProvider(new HistoryCorrelationIdProvider(projectKey), false);
        return ProjectApiRoot.fromClient(projectKey, this.builder.build());
    }

    public ProjectApiRoot build(String projectKey) {
        this.addCorrelationIdProvider(new HistoryCorrelationIdProvider(projectKey), false);
        return ProjectApiRoot.fromClient(projectKey, this.builder.build());
    }
}

