/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.ml.defaultconfig;

import com.commercetools.ml.client.ApiRoot;
import com.commercetools.ml.client.ByProjectKeyRequestBuilder;
import com.commercetools.ml.client.MLCorrelationIdProvider;
import com.commercetools.ml.client.ProjectApiRoot;
import com.commercetools.ml.defaultconfig.ServiceRegion;
import dev.failsafe.spi.Scheduler;
import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.ClientBuilder;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.ServiceRegionConfig;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.error.HttpExceptionFactory;
import io.vrap.rmf.base.client.http.CorrelationIdProvider;
import io.vrap.rmf.base.client.http.ErrorMiddleware;
import io.vrap.rmf.base.client.http.FailsafeRetryPolicyBuilderOptions;
import io.vrap.rmf.base.client.http.HandlerStack;
import io.vrap.rmf.base.client.http.InternalLoggerFactory;
import io.vrap.rmf.base.client.http.InternalLoggerMiddleware;
import io.vrap.rmf.base.client.http.Middleware;
import io.vrap.rmf.base.client.http.OAuthMiddleware;
import io.vrap.rmf.base.client.http.QueueRequestMiddleware;
import io.vrap.rmf.base.client.http.RetryRequestMiddleware;
import io.vrap.rmf.base.client.oauth2.ClientCredentials;
import io.vrap.rmf.base.client.oauth2.TokenSupplier;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.slf4j.event.Level;

public class MLApiRootBuilder {
    private final ClientBuilder builder;

    private MLApiRootBuilder(ClientBuilder builder) {
        this.builder = builder;
    }

    public static MLApiRootBuilder of() {
        return new MLApiRootBuilder(ClientBuilder.of());
    }

    public static MLApiRootBuilder of(VrapHttpClient httpClient) {
        return new MLApiRootBuilder(ClientBuilder.of((VrapHttpClient)httpClient));
    }

    public static MLApiRootBuilder of(HandlerStack stack) {
        return new MLApiRootBuilder(ClientBuilder.of((HandlerStack)stack));
    }

    public MLApiRootBuilder withAuthCircuitBreaker() {
        this.builder.withAuthCircuitBreaker();
        return this;
    }

    public MLApiRootBuilder withoutAuthCircuitBreaker() {
        this.builder.withoutAuthCircuitBreaker();
        return this;
    }

    public MLApiRootBuilder withAuthRetries(int authRetries) {
        this.builder.withAuthRetries(authRetries);
        return this;
    }

    public MLApiRootBuilder withHandlerStack(HandlerStack stack) {
        this.builder.withHandlerStack(stack);
        return this;
    }

    public MLApiRootBuilder withHttpClient(VrapHttpClient httpClient) {
        this.builder.withHttpClient(httpClient);
        return this;
    }

    public MLApiRootBuilder withSerializer(ResponseSerializer serializer) {
        this.builder.withSerializer(serializer);
        return this;
    }

    public MLApiRootBuilder withSerializer(Supplier<ResponseSerializer> serializer) {
        this.builder.withSerializer(serializer);
        return this;
    }

    public MLApiRootBuilder withHttpExceptionFactory(HttpExceptionFactory factory) {
        this.builder.withHttpExceptionFactory(factory);
        return this;
    }

    public MLApiRootBuilder withHttpExceptionFactory(Function<ResponseSerializer, HttpExceptionFactory> factory) {
        this.builder.withHttpExceptionFactory(factory);
        return this;
    }

    public MLApiRootBuilder withHttpExceptionFactory(Supplier<HttpExceptionFactory> factory) {
        this.builder.withHttpExceptionFactory(factory);
        return this;
    }

    public MLApiRootBuilder defaultClient(ClientCredentials credentials) {
        return this.defaultClient(credentials, ServiceRegion.GCP_EUROPE);
    }

    public MLApiRootBuilder defaultClient(ClientCredentials credentials, ServiceRegionConfig serviceRegion) {
        this.builder.defaultClient(credentials, serviceRegion);
        return this;
    }

    public MLApiRootBuilder defaultClient(ClientCredentials credentials, String tokenEndpoint, String apiEndpoint) {
        return this.defaultClient(URI.create(apiEndpoint)).withClientCredentialsFlow(credentials, tokenEndpoint);
    }

    public MLApiRootBuilder defaultClient(String apiEndpoint, ClientCredentials credentials, String tokenEndpoint) {
        return this.defaultClient(URI.create(apiEndpoint)).withClientCredentialsFlow(credentials, tokenEndpoint);
    }

    public MLApiRootBuilder defaultClient(String apiEndpoint) {
        return this.defaultClient(URI.create(apiEndpoint));
    }

    public MLApiRootBuilder defaultClient(URI apiEndpoint) {
        this.builder.defaultClient(apiEndpoint);
        return this;
    }

    public MLApiRootBuilder withClientCredentialsFlow(ClientCredentials credentials, String tokenEndpoint) {
        this.builder.withClientCredentialsFlow(credentials, tokenEndpoint);
        return this;
    }

    public MLApiRootBuilder withClientCredentialsFlow(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient) {
        this.builder.withClientCredentialsFlow(credentials, tokenEndpoint, httpClient);
        return this;
    }

    public MLApiRootBuilder withClientCredentialsFlow(ClientCredentials credentials, URI tokenEndpoint) {
        this.builder.withClientCredentialsFlow(credentials, tokenEndpoint);
        return this;
    }

    public MLApiRootBuilder withClientCredentialsFlow(ClientCredentials credentials, URI tokenEndpoint, VrapHttpClient httpClient) {
        this.builder.withClientCredentialsFlow(credentials, tokenEndpoint, httpClient);
        return this;
    }

    public MLApiRootBuilder withStaticTokenFlow(AuthenticationToken token) {
        this.builder.withStaticTokenFlow(token);
        return this;
    }

    public MLApiRootBuilder withAnonymousSessionFlow(ClientCredentials credentials, String tokenEndpoint) {
        this.builder.withAnonymousSessionFlow(credentials, tokenEndpoint);
        return this;
    }

    public MLApiRootBuilder withAnonymousSessionFlow(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient) {
        this.builder.withAnonymousSessionFlow(credentials, tokenEndpoint, httpClient);
        return this;
    }

    public MLApiRootBuilder withGlobalCustomerPasswordFlow(ClientCredentials credentials, String email, String password, String tokenEndpoint) {
        this.builder.withGlobalCustomerPasswordFlow(credentials, email, password, tokenEndpoint);
        return this;
    }

    public MLApiRootBuilder withGlobalCustomerPasswordFlow(ClientCredentials credentials, String email, String password, String tokenEndpoint, VrapHttpClient httpClient) {
        this.builder.withGlobalCustomerPasswordFlow(credentials, email, password, tokenEndpoint, httpClient);
        return this;
    }

    public MLApiRootBuilder addAcceptGZipMiddleware() {
        this.builder.addAcceptGZipMiddleware();
        return this;
    }

    public MLApiRootBuilder withErrorMiddleware() {
        this.builder.withErrorMiddleware();
        return this;
    }

    public MLApiRootBuilder withErrorMiddleware(ErrorMiddleware errorMiddleware) {
        this.builder.withErrorMiddleware(errorMiddleware);
        return this;
    }

    public MLApiRootBuilder withRetryMiddleware(Supplier<RetryRequestMiddleware> retryMiddleware) {
        this.builder.withRetryMiddleware(retryMiddleware);
        return this;
    }

    public MLApiRootBuilder withRetryMiddleware(RetryRequestMiddleware retryMiddleware) {
        this.builder.withRetryMiddleware(retryMiddleware);
        return this;
    }

    public MLApiRootBuilder withRetryMiddleware(int maxRetries) {
        this.builder.withRetryMiddleware(maxRetries);
        return this;
    }

    public MLApiRootBuilder withRetryMiddleware(int maxRetries, List<Integer> statusCodes) {
        this.builder.withRetryMiddleware(maxRetries, statusCodes);
        return this;
    }

    public MLApiRootBuilder withRetryMiddleware(int maxRetries, List<Integer> statusCodes, List<Class<? extends Throwable>> failures) {
        this.builder.withRetryMiddleware(maxRetries, statusCodes, failures);
        return this;
    }

    public MLApiRootBuilder withRetryMiddleware(int maxRetries, long delay, long maxDelay, List<Integer> statusCodes, List<Class<? extends Throwable>> failures, FailsafeRetryPolicyBuilderOptions fn) {
        this.builder.withRetryMiddleware(maxRetries, delay, maxDelay, statusCodes, failures, fn);
        return this;
    }

    public MLApiRootBuilder withRetryMiddleware(int maxRetries, long delay, long maxDelay, FailsafeRetryPolicyBuilderOptions fn) {
        this.builder.withRetryMiddleware(maxRetries, delay, maxDelay, fn);
        return this;
    }

    public MLApiRootBuilder withQueueMiddleware(Supplier<QueueRequestMiddleware> queueMiddleware) {
        return this.with(clientBuilder -> clientBuilder.withQueueMiddleware(queueMiddleware));
    }

    public MLApiRootBuilder withQueueMiddleware(QueueRequestMiddleware queueMiddleware) {
        return this.with(clientBuilder -> clientBuilder.withQueueMiddleware(queueMiddleware));
    }

    public MLApiRootBuilder withQueueMiddleware(int maxRequests, Duration maxWaitTime) {
        return this.with(clientBuilder -> clientBuilder.withQueueMiddleware(maxRequests, maxWaitTime));
    }

    public MLApiRootBuilder withQueueMiddleware(Scheduler scheduler, int maxRequests, Duration maxWaitTime) {
        return this.with(clientBuilder -> clientBuilder.withQueueMiddleware(scheduler, maxRequests, maxWaitTime));
    }

    public MLApiRootBuilder withQueueMiddleware(ScheduledExecutorService executorService, int maxRequests, Duration maxWaitTime) {
        return this.with(clientBuilder -> clientBuilder.withQueueMiddleware(executorService, maxRequests, maxWaitTime));
    }

    public MLApiRootBuilder withQueueMiddleware(ExecutorService executorService, int maxRequests, Duration maxWaitTime) {
        return this.with(clientBuilder -> clientBuilder.withQueueMiddleware(executorService, maxRequests, maxWaitTime));
    }

    public MLApiRootBuilder withOAuthMiddleware(Supplier<OAuthMiddleware> oAuthMiddleware) {
        this.builder.withOAuthMiddleware(oAuthMiddleware);
        return this;
    }

    public MLApiRootBuilder withOAuthMiddleware(OAuthMiddleware oAuthMiddleware) {
        this.builder.withOAuthMiddleware(oAuthMiddleware);
        return this;
    }

    public MLApiRootBuilder withTokenSupplier(TokenSupplier tokenSupplier) {
        this.builder.withTokenSupplier(tokenSupplier);
        return this;
    }

    public MLApiRootBuilder withTokenSupplier(Supplier<TokenSupplier> tokenSupplier) {
        this.builder.withTokenSupplier(tokenSupplier);
        return this;
    }

    public MLApiRootBuilder withInternalLoggerMiddleware(InternalLoggerMiddleware internalLoggerMiddleware) {
        this.builder.withInternalLoggerMiddleware(internalLoggerMiddleware);
        return this;
    }

    public MLApiRootBuilder withInternalLoggerFactory(InternalLoggerFactory internalLoggerFactory) {
        this.builder.withInternalLoggerFactory(internalLoggerFactory);
        return this;
    }

    public MLApiRootBuilder withInternalLoggerFactory(InternalLoggerFactory internalLoggerFactory, Level responseLogEvent, Level deprecationLogEvent) {
        this.builder.withInternalLoggerFactory(internalLoggerFactory, responseLogEvent, deprecationLogEvent);
        return this;
    }

    public MLApiRootBuilder withInternalLoggerFactory(InternalLoggerFactory internalLoggerFactory, Level responseLogEvent, Level deprecationLogEvent, Level defaultExceptionLogEvent, Map<Class<? extends Throwable>, Level> exceptionLogEvents) {
        this.builder.withInternalLoggerFactory(internalLoggerFactory, responseLogEvent, deprecationLogEvent, defaultExceptionLogEvent, exceptionLogEvents);
        return this;
    }

    public MLApiRootBuilder withApiBaseUrl(String apiBaseUrl) {
        this.builder.withApiBaseUrl(apiBaseUrl);
        return this;
    }

    public MLApiRootBuilder withApiBaseUrl(URI apiBaseUrl) {
        this.builder.withApiBaseUrl(apiBaseUrl);
        return this;
    }

    public MLApiRootBuilder withUserAgentSupplier(Supplier<String> userAgentSupplier) {
        this.builder.withUserAgentSupplier(userAgentSupplier);
        return this;
    }

    public MLApiRootBuilder addCorrelationIdProvider(@Nullable CorrelationIdProvider correlationIdProvider) {
        return this.addCorrelationIdProvider(correlationIdProvider, true);
    }

    private MLApiRootBuilder addCorrelationIdProvider(@Nullable CorrelationIdProvider correlationIdProvider, boolean replace) {
        this.builder.addCorrelationIdProvider(correlationIdProvider, replace);
        return this;
    }

    public MLApiRootBuilder withMiddleware(Middleware middleware, Middleware ... middlewares) {
        this.builder.withMiddleware(middleware, middlewares);
        return this;
    }

    public MLApiRootBuilder addMiddleware(Middleware middleware, Middleware ... middlewares) {
        this.builder.addMiddleware(middleware, middlewares);
        return this;
    }

    public MLApiRootBuilder withMiddlewares(List<Middleware> middlewares) {
        this.builder.withMiddlewares(middlewares);
        return this;
    }

    public MLApiRootBuilder addMiddlewares(List<Middleware> middlewares) {
        this.builder.addMiddlewares(middlewares);
        return this;
    }

    public MLApiRootBuilder with(UnaryOperator<ClientBuilder> builderUnaryOperator) {
        builderUnaryOperator.apply(this.builder);
        return this;
    }

    public ApiRoot build() {
        return ApiRoot.fromClient(this.clientSupplier().get());
    }

    public ApiHttpClient buildClient() {
        return this.clientSupplier().get();
    }

    public Supplier<ApiHttpClient> clientSupplier() {
        return () -> ((ClientBuilder)this.builder).build();
    }

    @Deprecated
    public ByProjectKeyRequestBuilder buildForProject(String projectKey) {
        this.addCorrelationIdProvider(new MLCorrelationIdProvider(projectKey), false);
        return ApiRoot.fromClient(this.builder.build()).withProjectKey(projectKey);
    }

    @Deprecated
    public ProjectApiRoot buildProjectRoot(String projectKey) {
        this.addCorrelationIdProvider(new MLCorrelationIdProvider(projectKey), false);
        return ProjectApiRoot.fromClient(projectKey, this.builder.build());
    }

    public ProjectApiRoot build(String projectKey) {
        this.addCorrelationIdProvider(new MLCorrelationIdProvider(projectKey), false);
        return ProjectApiRoot.fromClient(projectKey, this.builder.build());
    }
}

