/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.ml.models.common;

import com.commercetools.ml.models.common.CategoryReference;
import com.commercetools.ml.models.common.CategoryReferenceBuilder;
import com.commercetools.ml.models.common.CategoryReferenceImpl;
import com.commercetools.ml.models.common.ProductReference;
import com.commercetools.ml.models.common.ProductReferenceBuilder;
import com.commercetools.ml.models.common.ProductReferenceImpl;
import com.commercetools.ml.models.common.ProductTypeReference;
import com.commercetools.ml.models.common.ProductTypeReferenceBuilder;
import com.commercetools.ml.models.common.ProductTypeReferenceImpl;
import com.commercetools.ml.models.common.ReferenceImpl;
import com.commercetools.ml.models.common.ReferenceTypeId;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

@JsonSubTypes(value={@JsonSubTypes.Type(value=CategoryReferenceImpl.class, name="category"), @JsonSubTypes.Type(value=ProductReferenceImpl.class, name="product"), @JsonSubTypes.Type(value=ProductTypeReferenceImpl.class, name="product-type")})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="typeId", defaultImpl=ReferenceImpl.class, visible=true)
@JsonDeserialize(as=ReferenceImpl.class)
@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public interface Reference {
    @NotNull
    @JsonProperty(value="typeId")
    public ReferenceTypeId getTypeId();

    @NotNull
    @JsonProperty(value="id")
    public String getId();

    public void setId(String var1);

    @Nullable
    public static Reference deepCopy(@Nullable Reference template) {
        if (template == null) {
            return null;
        }
        if (template instanceof CategoryReference) {
            return CategoryReference.deepCopy((CategoryReference)template);
        }
        if (template instanceof ProductReference) {
            return ProductReference.deepCopy((ProductReference)template);
        }
        if (template instanceof ProductTypeReference) {
            return ProductTypeReference.deepCopy((ProductTypeReference)template);
        }
        ReferenceImpl instance = new ReferenceImpl();
        instance.setId(template.getId());
        return instance;
    }

    public static CategoryReferenceBuilder categoryBuilder() {
        return CategoryReferenceBuilder.of();
    }

    public static ProductReferenceBuilder productBuilder() {
        return ProductReferenceBuilder.of();
    }

    public static ProductTypeReferenceBuilder productTypeBuilder() {
        return ProductTypeReferenceBuilder.of();
    }

    default public <T> T withReference(Function<Reference, T> helper) {
        return helper.apply(this);
    }

    public static TypeReference<Reference> typeReference() {
        return new TypeReference<Reference>(){

            public String toString() {
                return "TypeReference<Reference>";
            }
        };
    }
}

