/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.ml.models.similar_products;

import com.commercetools.ml.models.similar_products.ProductSetSelector;
import com.commercetools.ml.models.similar_products.SimilarProductSearchRequestBuilder;
import com.commercetools.ml.models.similar_products.SimilarProductSearchRequestImpl;
import com.commercetools.ml.models.similar_products.SimilarityMeasures;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.Valid;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
@JsonDeserialize(as=SimilarProductSearchRequestImpl.class)
public interface SimilarProductSearchRequest {
    @JsonProperty(value="limit")
    public Long getLimit();

    @JsonProperty(value="offset")
    public Long getOffset();

    @JsonProperty(value="language")
    public String getLanguage();

    @JsonProperty(value="currencyCode")
    public String getCurrencyCode();

    @Valid
    @JsonProperty(value="similarityMeasures")
    public SimilarityMeasures getSimilarityMeasures();

    @Valid
    @JsonProperty(value="productSetSelectors")
    public List<ProductSetSelector> getProductSetSelectors();

    @JsonProperty(value="confidenceMin")
    public Double getConfidenceMin();

    @JsonProperty(value="confidenceMax")
    public Double getConfidenceMax();

    public void setLimit(Long var1);

    public void setOffset(Long var1);

    public void setLanguage(String var1);

    public void setCurrencyCode(String var1);

    public void setSimilarityMeasures(SimilarityMeasures var1);

    @JsonIgnore
    public void setProductSetSelectors(ProductSetSelector ... var1);

    public void setProductSetSelectors(List<ProductSetSelector> var1);

    public void setConfidenceMin(Double var1);

    public void setConfidenceMax(Double var1);

    public static SimilarProductSearchRequest of() {
        return new SimilarProductSearchRequestImpl();
    }

    public static SimilarProductSearchRequest of(SimilarProductSearchRequest template) {
        SimilarProductSearchRequestImpl instance = new SimilarProductSearchRequestImpl();
        instance.setLimit(template.getLimit());
        instance.setOffset(template.getOffset());
        instance.setLanguage(template.getLanguage());
        instance.setCurrencyCode(template.getCurrencyCode());
        instance.setSimilarityMeasures(template.getSimilarityMeasures());
        instance.setProductSetSelectors(template.getProductSetSelectors());
        instance.setConfidenceMin(template.getConfidenceMin());
        instance.setConfidenceMax(template.getConfidenceMax());
        return instance;
    }

    @Nullable
    public static SimilarProductSearchRequest deepCopy(@Nullable SimilarProductSearchRequest template) {
        if (template == null) {
            return null;
        }
        SimilarProductSearchRequestImpl instance = new SimilarProductSearchRequestImpl();
        instance.setLimit(template.getLimit());
        instance.setOffset(template.getOffset());
        instance.setLanguage(template.getLanguage());
        instance.setCurrencyCode(template.getCurrencyCode());
        instance.setSimilarityMeasures(SimilarityMeasures.deepCopy(template.getSimilarityMeasures()));
        instance.setProductSetSelectors((List<ProductSetSelector>)Optional.ofNullable(template.getProductSetSelectors()).map(t -> t.stream().map(ProductSetSelector::deepCopy).collect(Collectors.toList())).orElse(null));
        instance.setConfidenceMin(template.getConfidenceMin());
        instance.setConfidenceMax(template.getConfidenceMax());
        return instance;
    }

    public static SimilarProductSearchRequestBuilder builder() {
        return SimilarProductSearchRequestBuilder.of();
    }

    public static SimilarProductSearchRequestBuilder builder(SimilarProductSearchRequest template) {
        return SimilarProductSearchRequestBuilder.of(template);
    }

    default public <T> T withSimilarProductSearchRequest(Function<SimilarProductSearchRequest, T> helper) {
        return helper.apply(this);
    }

    public static TypeReference<SimilarProductSearchRequest> typeReference() {
        return new TypeReference<SimilarProductSearchRequest>(){

            public String toString() {
                return "TypeReference<SimilarProductSearchRequest>";
            }
        };
    }
}

