/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.ml.models.similar_products;

import com.commercetools.ml.models.similar_products.ProductSetSelector;
import com.commercetools.ml.models.similar_products.ProductSetSelectorBuilder;
import com.commercetools.ml.models.similar_products.SimilarProductSearchRequest;
import com.commercetools.ml.models.similar_products.SimilarProductSearchRequestImpl;
import com.commercetools.ml.models.similar_products.SimilarityMeasures;
import com.commercetools.ml.models.similar_products.SimilarityMeasuresBuilder;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class SimilarProductSearchRequestBuilder
implements Builder<SimilarProductSearchRequest> {
    @Nullable
    private Long limit;
    @Nullable
    private Long offset;
    @Nullable
    private String language;
    @Nullable
    private String currencyCode;
    @Nullable
    private SimilarityMeasures similarityMeasures;
    @Nullable
    private List<ProductSetSelector> productSetSelectors;
    @Nullable
    private Double confidenceMin;
    @Nullable
    private Double confidenceMax;

    public SimilarProductSearchRequestBuilder limit(@Nullable Long limit) {
        this.limit = limit;
        return this;
    }

    public SimilarProductSearchRequestBuilder offset(@Nullable Long offset) {
        this.offset = offset;
        return this;
    }

    public SimilarProductSearchRequestBuilder language(@Nullable String language) {
        this.language = language;
        return this;
    }

    public SimilarProductSearchRequestBuilder currencyCode(@Nullable String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    public SimilarProductSearchRequestBuilder similarityMeasures(Function<SimilarityMeasuresBuilder, SimilarityMeasuresBuilder> builder) {
        this.similarityMeasures = builder.apply(SimilarityMeasuresBuilder.of()).build();
        return this;
    }

    public SimilarProductSearchRequestBuilder withSimilarityMeasures(Function<SimilarityMeasuresBuilder, SimilarityMeasures> builder) {
        this.similarityMeasures = builder.apply(SimilarityMeasuresBuilder.of());
        return this;
    }

    public SimilarProductSearchRequestBuilder similarityMeasures(@Nullable SimilarityMeasures similarityMeasures) {
        this.similarityMeasures = similarityMeasures;
        return this;
    }

    public SimilarProductSearchRequestBuilder productSetSelectors(ProductSetSelector ... productSetSelectors) {
        this.productSetSelectors = new ArrayList<ProductSetSelector>(Arrays.asList(productSetSelectors));
        return this;
    }

    public SimilarProductSearchRequestBuilder productSetSelectors(@Nullable List<ProductSetSelector> productSetSelectors) {
        this.productSetSelectors = productSetSelectors;
        return this;
    }

    public SimilarProductSearchRequestBuilder plusProductSetSelectors(ProductSetSelector ... productSetSelectors) {
        if (this.productSetSelectors == null) {
            this.productSetSelectors = new ArrayList<ProductSetSelector>();
        }
        this.productSetSelectors.addAll(Arrays.asList(productSetSelectors));
        return this;
    }

    public SimilarProductSearchRequestBuilder plusProductSetSelectors(Function<ProductSetSelectorBuilder, ProductSetSelectorBuilder> builder) {
        if (this.productSetSelectors == null) {
            this.productSetSelectors = new ArrayList<ProductSetSelector>();
        }
        this.productSetSelectors.add(builder.apply(ProductSetSelectorBuilder.of()).build());
        return this;
    }

    public SimilarProductSearchRequestBuilder withProductSetSelectors(Function<ProductSetSelectorBuilder, ProductSetSelectorBuilder> builder) {
        this.productSetSelectors = new ArrayList<ProductSetSelector>();
        this.productSetSelectors.add(builder.apply(ProductSetSelectorBuilder.of()).build());
        return this;
    }

    public SimilarProductSearchRequestBuilder addProductSetSelectors(Function<ProductSetSelectorBuilder, ProductSetSelector> builder) {
        return this.plusProductSetSelectors(builder.apply(ProductSetSelectorBuilder.of()));
    }

    public SimilarProductSearchRequestBuilder setProductSetSelectors(Function<ProductSetSelectorBuilder, ProductSetSelector> builder) {
        return this.productSetSelectors(builder.apply(ProductSetSelectorBuilder.of()));
    }

    public SimilarProductSearchRequestBuilder confidenceMin(@Nullable Double confidenceMin) {
        this.confidenceMin = confidenceMin;
        return this;
    }

    public SimilarProductSearchRequestBuilder confidenceMax(@Nullable Double confidenceMax) {
        this.confidenceMax = confidenceMax;
        return this;
    }

    @Nullable
    public Long getLimit() {
        return this.limit;
    }

    @Nullable
    public Long getOffset() {
        return this.offset;
    }

    @Nullable
    public String getLanguage() {
        return this.language;
    }

    @Nullable
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @Nullable
    public SimilarityMeasures getSimilarityMeasures() {
        return this.similarityMeasures;
    }

    @Nullable
    public List<ProductSetSelector> getProductSetSelectors() {
        return this.productSetSelectors;
    }

    @Nullable
    public Double getConfidenceMin() {
        return this.confidenceMin;
    }

    @Nullable
    public Double getConfidenceMax() {
        return this.confidenceMax;
    }

    public SimilarProductSearchRequest build() {
        return new SimilarProductSearchRequestImpl(this.limit, this.offset, this.language, this.currencyCode, this.similarityMeasures, this.productSetSelectors, this.confidenceMin, this.confidenceMax);
    }

    public SimilarProductSearchRequest buildUnchecked() {
        return new SimilarProductSearchRequestImpl(this.limit, this.offset, this.language, this.currencyCode, this.similarityMeasures, this.productSetSelectors, this.confidenceMin, this.confidenceMax);
    }

    public static SimilarProductSearchRequestBuilder of() {
        return new SimilarProductSearchRequestBuilder();
    }

    public static SimilarProductSearchRequestBuilder of(SimilarProductSearchRequest template) {
        SimilarProductSearchRequestBuilder builder = new SimilarProductSearchRequestBuilder();
        builder.limit = template.getLimit();
        builder.offset = template.getOffset();
        builder.language = template.getLanguage();
        builder.currencyCode = template.getCurrencyCode();
        builder.similarityMeasures = template.getSimilarityMeasures();
        builder.productSetSelectors = template.getProductSetSelectors();
        builder.confidenceMin = template.getConfidenceMin();
        builder.confidenceMax = template.getConfidenceMax();
        return builder;
    }
}

