/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.AutoCloseableService;
import io.vrap.rmf.base.client.ClientRequestCommand;
import io.vrap.rmf.base.client.ContextApiHttpClient;
import io.vrap.rmf.base.client.ContextAware;
import io.vrap.rmf.base.client.ResponseSerializer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class ContextApiHttpClientImpl
extends AutoCloseableService
implements ContextApiHttpClient {
    private final ApiHttpClient client;
    private Map<Object, Object> contextMap;
    private final Consumer<ContextAware<ContextApiHttpClient>> consumer;

    public ContextApiHttpClientImpl(ApiHttpClient client) {
        this(client, new HashMap<Object, Object>(), null);
    }

    public ContextApiHttpClientImpl(ApiHttpClient client, Map<Object, Object> contextMap) {
        this(client, contextMap, null);
    }

    public ContextApiHttpClientImpl(ApiHttpClient client, Map<Object, Object> contextMap, Consumer<ContextAware<ContextApiHttpClient>> consumer) {
        this.client = client;
        this.contextMap = contextMap;
        this.consumer = consumer;
    }

    public ContextApiHttpClientImpl(ContextApiHttpClientImpl c) {
        this.client = c.client;
        this.contextMap = c.contextMap;
        this.consumer = c.consumer;
    }

    @Override
    public Map<Object, Object> getContextMap() {
        return this.contextMap;
    }

    @Override
    public ContextApiHttpClient withContextMap(Map<Object, Object> contextMap) {
        ContextApiHttpClientImpl client = this.copy();
        client.contextMap = new HashMap<Object, Object>(contextMap);
        return client;
    }

    @Override
    public <T> T getContext(Class<T> key) {
        return (T)this.contextMap.get(key);
    }

    @Override
    public <T> ContextApiHttpClient addContext(T value) {
        ContextApiHttpClientImpl client = this.copy();
        HashMap<Object, Object> contextMap = new HashMap<Object, Object>(client.contextMap);
        contextMap.put(value.getClass(), value);
        client.contextMap = contextMap;
        return client;
    }

    @Override
    public Object getContext(Object key) {
        return this.contextMap.get(key);
    }

    @Override
    public ContextApiHttpClient addContext(Object key, Object value) {
        ContextApiHttpClientImpl client = this.copy();
        HashMap<Object, Object> contextMap = new HashMap<Object, Object>(client.contextMap);
        contextMap.put(key, value);
        client.contextMap = contextMap;
        return client;
    }

    private ContextApiHttpClientImpl copy() {
        return new ContextApiHttpClientImpl(this);
    }

    private void restoreContext() {
        Optional.ofNullable(this.consumer).ifPresent(c -> c.accept(this));
    }

    @Override
    public <O> CompletableFuture<ApiHttpResponse<O>> execute(ApiHttpRequest request, Class<O> outputType) {
        this.restoreContext();
        return this.client.execute((ApiHttpRequest)request.withContextMap((Map)this.contextMap), outputType);
    }

    @Override
    public <O> CompletableFuture<ApiHttpResponse<O>> execute(ApiHttpRequest request, TypeReference<O> outputType) {
        this.restoreContext();
        return this.client.execute((ApiHttpRequest)request.withContextMap((Map)this.contextMap), outputType);
    }

    @Override
    public <O> CompletableFuture<ApiHttpResponse<O>> execute(ApiHttpRequest request, JavaType outputType) {
        this.restoreContext();
        return this.client.execute((ApiHttpRequest)request.withContextMap((Map)this.contextMap), outputType);
    }

    @Override
    public <O> CompletableFuture<ApiHttpResponse<O>> execute(ClientRequestCommand<O> method) {
        this.restoreContext();
        return method.execute(this);
    }

    @Override
    public ResponseSerializer getSerializerService() {
        return this.client.getSerializerService();
    }

    @Override
    public URI getBaseUri() {
        return this.client.getBaseUri();
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> execute(ApiHttpRequest request) {
        this.restoreContext();
        return this.client.execute((ApiHttpRequest)request.withContextMap((Map)this.contextMap));
    }

    @Override
    protected void internalClose() {
        ContextApiHttpClientImpl.closeQuietly(this.client);
    }
}

