/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.ResponseSerializer;
import java.io.IOException;

class ResponseSerializerImpl
implements ResponseSerializer {
    private final ObjectMapper mapper;

    public ResponseSerializerImpl(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <O> ApiHttpResponse<O> convertResponse(ApiHttpResponse<byte[]> response, Class<O> outputType) {
        try {
            if (response.getBody() == null) {
                return response;
            }
            Object newBody = this.mapper.readValue(response.getBody(), outputType);
            return new ApiHttpResponse<Object>(response.getStatusCode(), response.getHeaders(), newBody, response.getMessage(), response.getContextMap());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <O> ApiHttpResponse<O> convertResponse(ApiHttpResponse<byte[]> response, JavaType outputType) {
        try {
            if (response.getBody() == null) {
                return response;
            }
            Object newBody = this.mapper.readValue(response.getBody(), outputType);
            return new ApiHttpResponse<Object>(response.getStatusCode(), response.getHeaders(), newBody, response.getMessage(), response.getContextMap());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <O> ApiHttpResponse<O> convertResponse(ApiHttpResponse<byte[]> response, TypeReference<O> outputType) {
        try {
            if (response.getBody() == null) {
                return response;
            }
            Object newBody = this.mapper.readValue(response.getBody(), outputType);
            return new ApiHttpResponse<Object>(response.getStatusCode(), response.getHeaders(), newBody, response.getMessage(), response.getContextMap());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] toJsonByteArray(Object value) throws JsonProcessingException {
        return this.mapper.writeValueAsBytes(value);
    }
}

