/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.AutoCloseableService;
import io.vrap.rmf.base.client.oauth2.InMemoryTokenSupplier;
import io.vrap.rmf.base.client.oauth2.RefreshableTokenSupplier;
import io.vrap.rmf.base.client.oauth2.TokenSupplier;
import io.vrap.rmf.base.client.utils.ClientUtils;
import java.time.Duration;

public class OAuthHandler
extends AutoCloseableService {
    public static final Duration WAIT_TIMEOUT = Duration.ofSeconds(5L);
    private final Duration waitTimeout;
    private final RefreshableTokenSupplier supplier;

    public OAuthHandler(TokenSupplier supplier) {
        this(supplier, WAIT_TIMEOUT);
    }

    public OAuthHandler(TokenSupplier supplier, Duration waitTimeout) {
        this.supplier = supplier instanceof RefreshableTokenSupplier ? (RefreshableTokenSupplier)supplier : new InMemoryTokenSupplier(supplier);
        this.waitTimeout = waitTimeout;
    }

    static String authHeader(AuthenticationToken token) {
        return "Bearer " + token.getAccessToken();
    }

    public AuthenticationToken getToken() {
        AuthenticationToken token = ClientUtils.blockingWait(this.supplier.getToken(), this.waitTimeout);
        if (token.isExpired()) {
            return this.refreshToken();
        }
        return token;
    }

    public AuthenticationToken refreshToken() {
        return ClientUtils.blockingWait(this.supplier.refreshToken(), this.waitTimeout);
    }

    @Override
    protected void internalClose() {
        if (this.supplier instanceof AutoCloseable) {
            OAuthHandler.closeQuietly((AutoCloseable)((Object)this.supplier));
        }
    }
}

