/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.Base;
import io.vrap.rmf.base.client.ClassReferenceContext;
import io.vrap.rmf.base.client.ContextAware;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ApiHttpResponse<U>
extends Base
implements ContextAware<ApiHttpResponse<U>> {
    private int statusCode;
    private ApiHttpHeaders headers;
    private U body;
    private String message;
    private Map<Object, Object> contextMap = new HashMap<Object, Object>();

    public ApiHttpResponse(int statusCode, ApiHttpHeaders headers, U body) {
        this(statusCode, headers, body, null);
    }

    public ApiHttpResponse(int statusCode, ApiHttpHeaders headers, U body, String message) {
        this.statusCode = statusCode;
        this.headers = Optional.ofNullable(headers).orElse(new ApiHttpHeaders());
        this.body = body;
        this.message = message;
    }

    public ApiHttpResponse(int statusCode, ApiHttpHeaders headers, U body, String message, Map<Object, Object> contextMap) {
        this.statusCode = statusCode;
        this.headers = Optional.ofNullable(headers).orElse(new ApiHttpHeaders());
        this.body = body;
        this.message = message;
        this.contextMap = contextMap;
    }

    public ApiHttpResponse(ApiHttpResponse<U> response) {
        this.statusCode = response.statusCode;
        this.headers = response.headers;
        this.body = response.body;
        this.message = response.message;
        this.contextMap = response.contextMap;
    }

    @Override
    public Map<Object, Object> getContextMap() {
        return this.contextMap;
    }

    @Override
    public ApiHttpResponse<U> withContextMap(Map<Object, Object> contextMap) {
        ApiHttpResponse<U> response = this.copy();
        response.contextMap = new HashMap<Object, Object>(contextMap);
        return response;
    }

    @Override
    public <T> T getContext(Class<T> key) {
        return (T)this.contextMap.get(key);
    }

    @Override
    public <T> ApiHttpResponse<U> addContext(T value) {
        ApiHttpResponse<U> response = this.copy();
        HashMap<Object, Object> contextMap = new HashMap<Object, Object>(response.contextMap);
        contextMap.put(value.getClass(), value);
        if (value instanceof ClassReferenceContext) {
            contextMap.put(((ClassReferenceContext)value).classReference(), value);
        }
        response.contextMap = contextMap;
        return response;
    }

    @Override
    public Object getContext(Object key) {
        return this.contextMap.get(key);
    }

    @Override
    public ApiHttpResponse<U> addContext(Object key, Object value) {
        ApiHttpResponse<U> response = this.copy();
        HashMap<Object, Object> contextMap = new HashMap<Object, Object>(response.contextMap);
        contextMap.put(key, value);
        response.contextMap = contextMap;
        return response;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ApiHttpResponse<U> withStatusCode(int statusCode) {
        ApiHttpResponse<U> response = this.copy();
        response.statusCode = statusCode;
        return response;
    }

    public ApiHttpHeaders getHeaders() {
        return this.headers;
    }

    public ApiHttpResponse<U> withHeaders(ApiHttpHeaders headers) {
        ApiHttpResponse<U> response = this.copy();
        response.headers = headers;
        return response;
    }

    public U getBody() {
        return this.body;
    }

    public ApiHttpResponse<U> withBody(U body) {
        ApiHttpResponse<U> response = this.copy();
        response.body = body;
        return response;
    }

    public String getMessage() {
        return this.message;
    }

    public ApiHttpResponse<U> withMessage(String message) {
        ApiHttpResponse<U> response = this.copy();
        response.message = message;
        return response;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("statusCode", this.statusCode).append("headers", (Object)this.headers).append("textInterpretedBody", (Object)this.getSecuredBody()).toString();
    }

    static String tryToFilter(String input) {
        return input.replaceAll("(\"\\w*([Pp]ass|access_token|refresh_token)\\w*\"):\"[^\"]*\"", "$1:\"**removed from output**\"");
    }

    public Optional<String> getBodyAsString() {
        if (this.body instanceof byte[]) {
            return Optional.of(this.body).map(b -> ApiHttpResponse.tryToFilter(new String((byte[])b, StandardCharsets.UTF_8)));
        }
        return Optional.ofNullable(this.body).map(Object::toString);
    }

    public String getSecuredBody() {
        return this.getBodyAsString().orElse("empty body");
    }

    private ApiHttpResponse<U> copy() {
        return new ApiHttpResponse<U>(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHttpResponse response = (ApiHttpResponse)o;
        return new EqualsBuilder().append(this.statusCode, response.statusCode).append((Object)this.headers, (Object)response.headers).append(this.body, response.body).append((Object)this.message, (Object)response.message).append(this.contextMap, response.contextMap).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.statusCode).append((Object)this.headers).append(this.body).append((Object)this.message).append(this.contextMap).toHashCode();
    }
}

