/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import io.vrap.rmf.base.client.ApiHttpClientImpl;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.ClientRequestCommand;
import io.vrap.rmf.base.client.CreateHttpRequestCommand;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.http.HandlerStack;
import io.vrap.rmf.base.client.utils.ClientUtils;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public interface ApiHttpClient
extends AutoCloseable,
VrapHttpClient {
    public static final String CLOSED_MESSAGE = "Client is already closed.";
    public static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(120L);

    default public <O> CompletableFuture<ApiHttpResponse<O>> execute(ApiHttpRequest request, Class<O> outputType) {
        return this.execute(request, (ApiHttpResponse<byte[]> apiHttpResponse) -> this.getSerializerService().convertResponse((ApiHttpResponse<byte[]>)apiHttpResponse, outputType));
    }

    default public <O> CompletableFuture<ApiHttpResponse<O>> execute(ApiHttpRequest request, TypeReference<O> outputType) {
        return this.execute(request, (ApiHttpResponse<byte[]> apiHttpResponse) -> this.getSerializerService().convertResponse((ApiHttpResponse<byte[]>)apiHttpResponse, outputType));
    }

    default public <O> CompletableFuture<ApiHttpResponse<O>> execute(ApiHttpRequest request, JavaType outputType) {
        return this.execute(request, (ApiHttpResponse<byte[]> apiHttpResponse) -> this.getSerializerService().convertResponse((ApiHttpResponse<byte[]>)apiHttpResponse, outputType));
    }

    default public <O> CompletableFuture<ApiHttpResponse<O>> execute(ApiHttpRequest request, Function<ApiHttpResponse<byte[]>, ApiHttpResponse<O>> mapper) {
        return this.execute(request).thenApply(mapper);
    }

    default public <O> CompletableFuture<ApiHttpResponse<O>> execute(ClientRequestCommand<O> method) {
        return method.execute(this);
    }

    default public <T, O> CompletableFuture<ApiHttpResponse<O>> execute(CreateHttpRequestCommand method, Class<O> outputType) {
        return this.execute(method, (ApiHttpResponse<byte[]> apiHttpResponse) -> this.getSerializerService().convertResponse((ApiHttpResponse<byte[]>)apiHttpResponse, outputType));
    }

    default public <O> CompletableFuture<ApiHttpResponse<O>> execute(CreateHttpRequestCommand method, JavaType outputType) {
        return this.execute(method, (ApiHttpResponse<byte[]> apiHttpResponse) -> this.getSerializerService().convertResponse((ApiHttpResponse<byte[]>)apiHttpResponse, outputType));
    }

    default public <O> CompletableFuture<ApiHttpResponse<O>> execute(CreateHttpRequestCommand method, TypeReference<O> outputType) {
        return this.execute(method, (ApiHttpResponse<byte[]> apiHttpResponse) -> this.getSerializerService().convertResponse((ApiHttpResponse<byte[]>)apiHttpResponse, outputType));
    }

    default public <O> CompletableFuture<ApiHttpResponse<O>> execute(CreateHttpRequestCommand method, Function<ApiHttpResponse<byte[]>, ApiHttpResponse<O>> mapper) {
        return this.execute(method.createHttpRequest()).thenApply(mapper);
    }

    default public <O> ApiHttpResponse<O> executeBlocking(CreateHttpRequestCommand method, Function<ApiHttpResponse<byte[]>, ApiHttpResponse<O>> mapper, Duration timeout) {
        ApiHttpRequest request = method.createHttpRequest();
        return (ApiHttpResponse)ClientUtils.blockingWait(this.execute(request).thenApply(mapper), request, timeout);
    }

    default public <O> ApiHttpResponse<O> executeBlocking(CreateHttpRequestCommand method, Class<O> outputType, Duration timeout) {
        return this.executeBlocking(method, (ApiHttpResponse<byte[]> apiHttpResponse) -> this.getSerializerService().convertResponse((ApiHttpResponse<byte[]>)apiHttpResponse, outputType), timeout);
    }

    default public <O> ApiHttpResponse<O> executeBlocking(CreateHttpRequestCommand method, JavaType outputType, Duration timeout) {
        return this.executeBlocking(method, (ApiHttpResponse<byte[]> apiHttpResponse) -> this.getSerializerService().convertResponse((ApiHttpResponse<byte[]>)apiHttpResponse, outputType), timeout);
    }

    default public <O> ApiHttpResponse<O> executeBlocking(CreateHttpRequestCommand method, TypeReference<O> outputType, Duration timeout) {
        return this.executeBlocking(method, (ApiHttpResponse<byte[]> apiHttpResponse) -> this.getSerializerService().convertResponse((ApiHttpResponse<byte[]>)apiHttpResponse, outputType), timeout);
    }

    default public CompletableFuture<ApiHttpResponse<byte[]>> send(CreateHttpRequestCommand method) {
        return this.execute(method.createHttpRequest());
    }

    default public <T> ApiHttpResponse<byte[]> sendBlocking(CreateHttpRequestCommand method, Duration timeout) {
        ApiHttpRequest request = method.createHttpRequest();
        return ClientUtils.blockingWait(this.execute(request), request, timeout);
    }

    public ResponseSerializer getSerializerService();

    public URI getBaseUri();

    public static ApiHttpClient of(String baseUri, HandlerStack stack) {
        return ApiHttpClient.of(URI.create(baseUri), stack, ResponseSerializer.of());
    }

    public static ApiHttpClient of(URI baseUri, HandlerStack stack) {
        return ApiHttpClient.of(baseUri, stack, ResponseSerializer.of());
    }

    public static ApiHttpClient of(String baseUri, HandlerStack stack, ResponseSerializer serializer) {
        return ApiHttpClient.of(URI.create(baseUri), stack, serializer);
    }

    public static ApiHttpClient of(URI baseUri, HandlerStack stack, ResponseSerializer serializer) {
        return new ApiHttpClientImpl(baseUri, stack, serializer);
    }
}

