/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.oauth2;

import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.oauth2.AnonymousFlowTokenSupplier;
import io.vrap.rmf.base.client.oauth2.RefreshableTokenSupplier;
import io.vrap.rmf.base.client.oauth2.TokenStorage;
import java.util.concurrent.CompletableFuture;

public class TokenStorageSupplier
implements RefreshableTokenSupplier {
    private final InternalLogger logger = InternalLogger.getLogger("commercetools.auth");
    private final TokenStorage storage;
    private final AnonymousFlowTokenSupplier anonymousFlowTokenSupplier;
    private final Object lock = new Object();
    private volatile CompletableFuture<AuthenticationToken> tokenFuture;

    public TokenStorageSupplier(TokenStorage storage, AnonymousFlowTokenSupplier supplier) {
        this.storage = storage;
        this.anonymousFlowTokenSupplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<AuthenticationToken> getToken() {
        Object object;
        AuthenticationToken token = this.storage.getToken();
        if (token != null && !token.isExpired()) {
            return CompletableFuture.completedFuture(token);
        }
        if (token != null && token.getRefreshToken() != null) {
            object = this.lock;
            synchronized (object) {
                if (this.tokenFuture == null) {
                    this.logger.debug(() -> "using refresh token flow");
                    this.tokenFuture = this.anonymousFlowTokenSupplier.refreshToken().thenApply(this::storeToken);
                }
            }
        }
        object = this.lock;
        synchronized (object) {
            if (this.tokenFuture == null) {
                this.logger.debug(() -> "using anonymous token flow");
                this.tokenFuture = this.anonymousFlowTokenSupplier.getToken().thenApply(this::storeToken);
            }
        }
        return this.tokenFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTokenFuture() {
        Object object = this.lock;
        synchronized (object) {
            this.tokenFuture = null;
        }
    }

    private AuthenticationToken storeToken(AuthenticationToken token) {
        this.storage.setToken(token);
        this.resetTokenFuture();
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<AuthenticationToken> refreshToken() {
        this.resetTokenFuture();
        AuthenticationToken token = this.storage.getToken();
        if (token != null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.tokenFuture == null && token.isExpired()) {
                    this.logger.debug(() -> "refresh token");
                    this.tokenFuture = this.anonymousFlowTokenSupplier.refreshToken().thenApply(this::storeToken);
                }
            }
            return this.tokenFuture;
        }
        return this.getToken();
    }
}

