/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.AutoCloseableService;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.http.HandlerStack;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ApiHttpClientImpl
extends AutoCloseableService
implements ApiHttpClient {
    private final HandlerStack stack;
    private final URI baseUri;
    private final ResponseSerializer serializer;

    public ApiHttpClientImpl(String baseUri, HandlerStack stack) {
        this(URI.create(baseUri), stack, ResponseSerializer.of());
    }

    public ApiHttpClientImpl(URI baseUri, HandlerStack stack) {
        this(baseUri, stack, ResponseSerializer.of());
    }

    public ApiHttpClientImpl(URI baseUri, HandlerStack stack, ResponseSerializer serializer) {
        this.stack = stack;
        this.baseUri = baseUri;
        this.serializer = serializer;
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> execute(ApiHttpRequest request) {
        this.rejectExecutionIfClosed("Client is already closed.");
        return this.stack.execute(request.resolve(this.baseUri));
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public ResponseSerializer getSerializerService() {
        return this.serializer;
    }

    @Override
    protected void internalClose() {
        ApiHttpClientImpl.closeQuietly(this.stack);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHttpClientImpl that = (ApiHttpClientImpl)o;
        return new EqualsBuilder().append((Object)this.stack, (Object)that.stack).append((Object)this.baseUri, (Object)that.baseUri).append((Object)this.serializer, (Object)that.serializer).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.stack).append((Object)this.baseUri).append((Object)this.serializer).toHashCode();
    }
}

