/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.oauth2;

import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpMethod;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.oauth2.BaseAuthTokenSupplier;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class ClientCredentialsTokenSupplier
extends BaseAuthTokenSupplier {
    public ClientCredentialsTokenSupplier(String clientId, String clientSecret, String scope, String tokenEndpoint, VrapHttpClient vrapHttpClient) {
        super(vrapHttpClient, ClientCredentialsTokenSupplier.constructApiHttpRequest(clientId, clientSecret, scope, tokenEndpoint));
    }

    public ClientCredentialsTokenSupplier(String clientId, String clientSecret, String scope, String tokenEndpoint, VrapHttpClient vrapHttpClient, ResponseSerializer serializer) {
        super(vrapHttpClient, ClientCredentialsTokenSupplier.constructApiHttpRequest(clientId, clientSecret, scope, tokenEndpoint), serializer);
    }

    private static ApiHttpRequest constructApiHttpRequest(String clientId, String clientSecret, String scope, String tokenEndpoint) {
        String auth = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes(StandardCharsets.UTF_8));
        ApiHttpHeaders headers = new ApiHttpHeaders().withHeader("Authorization", String.format("Basic %s", auth)).withHeader("Content-Type", "application/x-www-form-urlencoded");
        String body = "";
        body = scope == null || scope.isEmpty() ? "grant_type=client_credentials" : String.format("grant_type=client_credentials&scope=%s", ClientCredentialsTokenSupplier.urlEncode(scope));
        return new ApiHttpRequest(ApiHttpMethod.POST, URI.create(tokenEndpoint), headers, body.getBytes(StandardCharsets.UTF_8));
    }
}

